/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.completion;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockConstants;

public record AmazonBedrockChatCompletionRequestTaskSettings(@Nullable Double temperature, @Nullable Double topP, @Nullable Double topK, @Nullable Integer maxNewTokens) {
    public static final AmazonBedrockChatCompletionRequestTaskSettings EMPTY_SETTINGS = new AmazonBedrockChatCompletionRequestTaskSettings(null, null, null, null);

    public static AmazonBedrockChatCompletionRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        Double temperature = ServiceUtils.extractOptionalDoubleInRange(map, "temperature", AmazonBedrockConstants.MIN_TEMPERATURE_TOP_P_TOP_K_VALUE, AmazonBedrockConstants.MAX_TEMPERATURE_TOP_P_TOP_K_VALUE, "task_settings", validationException);
        Double topP = ServiceUtils.extractOptionalDoubleInRange(map, "top_p", AmazonBedrockConstants.MIN_TEMPERATURE_TOP_P_TOP_K_VALUE, AmazonBedrockConstants.MAX_TEMPERATURE_TOP_P_TOP_K_VALUE, "task_settings", validationException);
        Double topK = ServiceUtils.extractOptionalDoubleInRange(map, "top_k", AmazonBedrockConstants.MIN_TEMPERATURE_TOP_P_TOP_K_VALUE, AmazonBedrockConstants.MAX_TEMPERATURE_TOP_P_TOP_K_VALUE, "task_settings", validationException);
        Integer maxNewTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_new_tokens", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AmazonBedrockChatCompletionRequestTaskSettings(temperature, topP, topK, maxNewTokens);
    }
}

