/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.client;

import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockClientCache;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockExecutor;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.AmazonBedrockResponseHandler;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.completion.AmazonBedrockChatCompletionResponseListener;

public class AmazonBedrockChatCompletionExecutor
extends AmazonBedrockExecutor {
    private final AmazonBedrockChatCompletionRequest chatCompletionRequest;

    protected AmazonBedrockChatCompletionExecutor(AmazonBedrockChatCompletionRequest request, AmazonBedrockResponseHandler responseHandler, Logger logger, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> inferenceResultsListener, AmazonBedrockClientCache clientCache) {
        super(request, responseHandler, logger, hasRequestCompletedFunction, inferenceResultsListener, clientCache);
        this.chatCompletionRequest = request;
    }

    @Override
    protected void executeClientRequest(AmazonBedrockBaseClient awsBedrockClient) {
        if (this.chatCompletionRequest.isStreaming()) {
            Flow.Publisher<? extends InferenceServiceResults.Result> publisher = this.chatCompletionRequest.executeStreamChatCompletionRequest(awsBedrockClient);
            this.inferenceResultsListener.onResponse((Object)new StreamingChatCompletionResults(publisher));
        } else {
            AmazonBedrockChatCompletionResponseListener chatCompletionResponseListener = new AmazonBedrockChatCompletionResponseListener(this.chatCompletionRequest, this.responseHandler, (ActionListener<InferenceServiceResults>)this.inferenceResultsListener);
            this.chatCompletionRequest.executeChatCompletionRequest(awsBedrockClient, chatCompletionResponseListener);
        }
    }
}

