/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockChatCompletionRequestManager;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.amazonbedrock.action.AmazonBedrockActionVisitor;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsModel;

public class AmazonBedrockActionCreator
implements AmazonBedrockActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;
    private final TimeValue timeout;

    public AmazonBedrockActionCreator(Sender sender, ServiceComponents serviceComponents, @Nullable TimeValue timeout) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
        this.timeout = timeout;
    }

    @Override
    public ExecutableAction create(AmazonBedrockEmbeddingsModel embeddingsModel, Map<String, Object> taskSettings) {
        AmazonBedrockEmbeddingsModel overriddenModel = AmazonBedrockEmbeddingsModel.of(embeddingsModel, taskSettings);
        AmazonBedrockEmbeddingsRequestManager requestManager = new AmazonBedrockEmbeddingsRequestManager(overriddenModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool(), this.timeout);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("Amazon Bedrock embeddings");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(AmazonBedrockChatCompletionModel completionModel, Map<String, Object> taskSettings) {
        AmazonBedrockChatCompletionModel overriddenModel = AmazonBedrockChatCompletionModel.of(completionModel, taskSettings);
        AmazonBedrockChatCompletionRequestManager requestManager = new AmazonBedrockChatCompletionRequestManager(overriddenModel, this.serviceComponents.threadPool(), this.timeout);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("Amazon Bedrock completion");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }
}

