/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchService;

public class AlibabaCloudSearchSparseTaskSettings
implements TaskSettings {
    public static final String NAME = "alibabacloud_search_sparse_embeddings_task_settings";
    public static final AlibabaCloudSearchSparseTaskSettings EMPTY_SETTINGS = new AlibabaCloudSearchSparseTaskSettings(null, null);
    static final String INPUT_TYPE = "input_type";
    static final String RETURN_TOKEN = "return_token";
    private final InputType inputType;
    private final Boolean returnToken;

    public static AlibabaCloudSearchSparseTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, AlibabaCloudSearchService.VALID_INPUT_TYPE_VALUES, validationException);
        Boolean returnToken = ServiceUtils.extractOptionalBoolean(map, RETURN_TOKEN, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AlibabaCloudSearchSparseTaskSettings(inputType, returnToken);
    }

    public static AlibabaCloudSearchSparseTaskSettings of(AlibabaCloudSearchSparseTaskSettings originalSettings, AlibabaCloudSearchSparseTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = AlibabaCloudSearchSparseTaskSettings.getValidInputType(originalSettings, requestTaskSettings);
        Boolean returnToken = requestTaskSettings.isReturnToken() != null ? requestTaskSettings.isReturnToken() : originalSettings.isReturnToken();
        return new AlibabaCloudSearchSparseTaskSettings(inputTypeToUse, returnToken);
    }

    private static InputType getValidInputType(AlibabaCloudSearchSparseTaskSettings originalSettings, AlibabaCloudSearchSparseTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (requestTaskSettings.inputType != null) {
            inputTypeToUse = requestTaskSettings.inputType;
        }
        return inputTypeToUse;
    }

    public AlibabaCloudSearchSparseTaskSettings(StreamInput in) throws IOException {
        this((InputType)in.readOptionalEnum(InputType.class), in.readOptionalBoolean());
    }

    public AlibabaCloudSearchSparseTaskSettings(@Nullable InputType inputType, Boolean returnToken) {
        AlibabaCloudSearchSparseTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.returnToken = returnToken;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (AlibabaCloudSearchService.VALID_INPUT_TYPE_VALUES.contains(inputType)) : InputType.invalidInputTypeMessage((InputType)inputType);
    }

    public boolean isEmpty() {
        return this.inputType == null && this.returnToken == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        if (this.returnToken != null) {
            builder.field(RETURN_TOKEN, this.returnToken);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public Boolean isReturnToken() {
        return this.returnToken;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
        out.writeOptionalBoolean(this.returnToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlibabaCloudSearchSparseTaskSettings that = (AlibabaCloudSearchSparseTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals(this.returnToken, that.returnToken);
    }

    public int hashCode() {
        return Objects.hash(this.inputType, this.returnToken);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AlibabaCloudSearchSparseTaskSettings updatedSettings = AlibabaCloudSearchSparseTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AlibabaCloudSearchSparseTaskSettings.of(this, updatedSettings);
    }
}

