/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.inference.rest.BaseInferenceAction;
import org.elasticsearch.xpack.inference.rest.ServerSentEventsRestActionListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestStreamInferenceAction
extends BaseInferenceAction {
    private final SetOnce<ThreadPool> threadPool;

    public RestStreamInferenceAction(SetOnce<ThreadPool> threadPool) {
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    public String getName() {
        return "stream_inference_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "_inference/{task_type_or_id}/_stream"), new RestHandler.Route(RestRequest.Method.POST, "_inference/{task_type_or_id}/{inference_id}/_stream"));
    }

    @Override
    protected ActionListener<InferenceAction.Response> listener(RestChannel channel) {
        return new ServerSentEventsRestActionListener(channel, this.threadPool);
    }

    @Override
    protected boolean shouldStream() {
        return true;
    }
}

