/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;

public interface SemanticTextUtils {
    public static List<String> nodeStringValues(String field, Object valueObj) {
        if (valueObj instanceof Number || valueObj instanceof Boolean) {
            return List.of(valueObj.toString());
        }
        if (valueObj instanceof String) {
            String value = (String)valueObj;
            return List.of(value);
        }
        if (valueObj instanceof Collection) {
            Collection values = (Collection)valueObj;
            ArrayList<String> valuesString = new ArrayList<String>();
            for (Object v : values) {
                if (v instanceof Number || v instanceof Boolean) {
                    valuesString.add(v.toString());
                    continue;
                }
                if (v instanceof String) {
                    String value = (String)v;
                    valuesString.add(value);
                    continue;
                }
                throw new ElasticsearchStatusException("Invalid format for field [{}], expected [String|Number|Boolean] got [{}]", RestStatus.BAD_REQUEST, new Object[]{field, valueObj.getClass().getSimpleName()});
            }
            return valuesString;
        }
        throw new ElasticsearchStatusException("Invalid format for field [{}], expected [String|Number|Boolean] got [{}]", RestStatus.BAD_REQUEST, new Object[]{field, valueObj.getClass().getSimpleName()});
    }

    public static void insertValue(String path, Map<?, ?> map, Object newValue) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return;
        }
        List<SuffixMap> suffixMaps = SemanticTextUtils.extractSuffixMaps(pathElements, 0, map);
        if (suffixMaps.isEmpty()) {
            throw new IllegalStateException("extractSuffixMaps returned an empty suffix map list");
        }
        if (suffixMaps.size() != 1) {
            throw new IllegalArgumentException("Path [" + path + "] could be inserted in " + suffixMaps.size() + " distinct ways, it is ambiguous which one to use");
        }
        SuffixMap suffixMap = suffixMaps.get(0);
        suffixMap.map().put(suffixMap.suffix(), newValue);
    }

    private static List<SuffixMap> extractSuffixMaps(String[] pathElements, int index, Object currentValue) {
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<SuffixMap> suffixMaps = new ArrayList<SuffixMap>(valueList.size());
            for (Object o : valueList) {
                suffixMaps.addAll(SemanticTextUtils.extractSuffixMaps(pathElements, index, o));
            }
            return suffixMaps;
        }
        if (currentValue instanceof Map) {
            Map map = (Map)currentValue;
            ArrayList<SuffixMap> suffixMaps = new ArrayList<SuffixMap>(map.size());
            Object key = pathElements[index];
            while (index < pathElements.length) {
                if (map.containsKey(key)) {
                    if (index + 1 == pathElements.length) {
                        suffixMaps.add(new SuffixMap((String)key, map));
                    } else {
                        suffixMaps.addAll(SemanticTextUtils.extractSuffixMaps(pathElements, index + 1, map.get(key)));
                    }
                }
                if (++index >= pathElements.length) continue;
                key = (String)key + "." + pathElements[index];
            }
            if (suffixMaps.isEmpty()) {
                suffixMaps.add(new SuffixMap((String)key, map));
            }
            return suffixMaps;
        }
        throw new IllegalArgumentException("Path [" + String.join((CharSequence)".", Arrays.copyOfRange(pathElements, 0, index)) + "] has value [" + currentValue + "] of type [" + currentValue.getClass().getSimpleName() + "], which cannot be traversed into further");
    }

    public record SuffixMap(String suffix, Map<String, Object> map) {
    }
}

