/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common.amazon;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class AwsSecretSettings
implements SecretSettings {
    public static final String NAME = "aws_secret_settings";
    private final SecureString accessKey;
    private final SecureString secretKey;

    public static AwsSecretSettings fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        SecureString secureAccessKey = ServiceUtils.extractRequiredSecureString(map, "access_key", "secret_settings", validationException);
        SecureString secureSecretKey = ServiceUtils.extractRequiredSecureString(map, "secret_key", "secret_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AwsSecretSettings(secureAccessKey, secureSecretKey);
    }

    public AwsSecretSettings(SecureString accessKey, SecureString secretKey) {
        this.accessKey = Objects.requireNonNull(accessKey);
        this.secretKey = Objects.requireNonNull(secretKey);
    }

    public AwsSecretSettings(StreamInput in) throws IOException {
        this.accessKey = in.readSecureString();
        this.secretKey = in.readSecureString();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeSecureString(this.accessKey);
        out.writeSecureString(this.secretKey);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("access_key", this.accessKey.toString());
        builder.field("secret_key", this.secretKey.toString());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AwsSecretSettings that = (AwsSecretSettings)object;
        return Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKey, this.secretKey);
    }

    public SecretSettings newSecretSettings(Map<String, Object> newSecrets) {
        return AwsSecretSettings.fromMap(new HashMap<String, Object>(newSecrets));
    }

    public SecureString accessKey() {
        return this.accessKey;
    }

    public SecureString secretKey() {
        return this.secretKey;
    }

    public static Stream<Map.Entry<String, SettingsConfiguration>> configuration(EnumSet<TaskType> supportedTaskTypes) {
        return Stream.of(Map.entry("access_key", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("A valid AWS access key that has permissions to use Amazon Bedrock.").setLabel("Access Key").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(true)).setUpdatable(Boolean.valueOf(true)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry("secret_key", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("A valid AWS secret key that is paired with the access_key.").setLabel("Secret Key").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(true)).setUpdatable(Boolean.valueOf(true)).setType(SettingsConfigurationFieldType.STRING).build()));
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> AwsSecretSettings.configuration(EnumSet.of(TaskType.TEXT_EMBEDDING, TaskType.COMPLETION)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

