/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.List;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.assembler.BoxedQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.Criterion;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.Timestamp;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;

public class SequenceCriterion
extends Criterion<BoxedQueryRequest> {
    private final int stage;
    private final BoxedQueryRequest queryRequest;
    private final List<HitExtractor> keys;
    private final HitExtractor timestamp;
    private final HitExtractor tiebreaker;
    private final HitExtractor implicitTiebreaker;
    private final boolean descending;
    private final boolean missing;

    public SequenceCriterion(int stage, BoxedQueryRequest queryRequest, List<HitExtractor> keys, HitExtractor timestamp, HitExtractor tiebreaker, HitExtractor implicitTiebreaker, boolean descending, boolean missing) {
        super(keys.size());
        this.stage = stage;
        this.queryRequest = queryRequest;
        this.keys = keys;
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
        this.implicitTiebreaker = implicitTiebreaker;
        this.descending = descending;
        this.missing = missing;
    }

    public int stage() {
        return this.stage;
    }

    public boolean descending() {
        return this.descending;
    }

    public BoxedQueryRequest queryRequest() {
        return this.queryRequest;
    }

    public Object[] key(SearchHit hit) {
        Object[] key = null;
        if (this.keySize() > 0) {
            Object[] docKeys = new Object[this.keySize()];
            for (int i = 0; i < this.keySize(); ++i) {
                docKeys[i] = this.keys.get(i).extract(hit);
            }
            key = docKeys;
        }
        return key;
    }

    public Ordinal ordinal(SearchHit hit) {
        Object implicitTbreaker;
        Object ts = this.timestamp.extract(hit);
        if (!(ts instanceof Timestamp)) {
            throw new EqlIllegalArgumentException("Expected timestamp as a Timestamp but got {}", ts.getClass());
        }
        Comparable tbreaker = null;
        if (this.tiebreaker != null) {
            Object tb = this.tiebreaker.extract(hit);
            if (tb != null && !(tb instanceof Comparable)) {
                throw new EqlIllegalArgumentException("Expected tiebreaker to be Comparable but got {}", tb);
            }
            tbreaker = (Comparable)tb;
        }
        if (!((implicitTbreaker = this.implicitTiebreaker.extract(hit)) instanceof Number)) {
            throw new EqlIllegalArgumentException("Expected _shard_doc/implicit tiebreaker as long but got [{}]", implicitTbreaker);
        }
        long timebreakerValue = ((Number)implicitTbreaker).longValue();
        return new Ordinal((Timestamp)ts, tbreaker, timebreakerValue);
    }

    public boolean missing() {
        return this.missing;
    }

    public Timestamp timestamp(SearchHit hit) {
        Object ts = this.timestamp.extract(hit);
        if (!(ts instanceof Timestamp)) {
            throw new EqlIllegalArgumentException("Expected timestamp as a Timestamp but got {}", ts.getClass());
        }
        return (Timestamp)ts;
    }

    public String toString() {
        return "[" + this.stage + "][" + this.descending + "]";
    }
}

