/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilter;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.analysis.common.AnalysisPredicateScript;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;

public class ScriptedConditionTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final AnalysisPredicateScript.Factory factory;
    private final List<String> filterNames;

    ScriptedConditionTokenFilterFactory(IndexSettings indexSettings, String name, Settings settings, ScriptService scriptService) {
        super(name, settings);
        Settings scriptSettings = settings.getAsSettings("script");
        Script script = Script.parse((Settings)scriptSettings);
        if (script.getType() != ScriptType.INLINE) {
            throw new IllegalArgumentException("Cannot use stored scripts in tokenfilter [" + name + "]");
        }
        this.factory = (AnalysisPredicateScript.Factory)scriptService.compile(script, AnalysisPredicateScript.CONTEXT);
        this.filterNames = settings.getAsList("filter");
        if (this.filterNames.isEmpty()) {
            throw new IllegalArgumentException("Empty list of filters provided to tokenfilter [" + name + "]");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        throw new UnsupportedOperationException("getChainAwareTokenFilterFactory should be called first");
    }

    public TokenFilterFactory getChainAwareTokenFilterFactory(IndexService.IndexCreationContext context, TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        final ArrayList<TokenFilterFactory> filters = new ArrayList<TokenFilterFactory>();
        ArrayList<TokenFilterFactory> existingChain = new ArrayList<TokenFilterFactory>(previousTokenFilters);
        for (String filter : this.filterNames) {
            TokenFilterFactory tff = allFilters.apply(filter);
            if (tff == null) {
                throw new IllegalArgumentException("ScriptedConditionTokenFilter [" + this.name() + "] refers to undefined token filter [" + filter + "]");
            }
            tff = tff.getChainAwareTokenFilterFactory(context, tokenizer, charFilters, existingChain, allFilters);
            filters.add(tff);
            existingChain.add(tff);
        }
        return new TokenFilterFactory(){

            public String name() {
                return ScriptedConditionTokenFilterFactory.this.name();
            }

            public TokenStream create(TokenStream tokenStream) {
                Function<TokenStream, TokenStream> filter = in -> {
                    for (TokenFilterFactory tff : filters) {
                        in = tff.create(in);
                    }
                    return in;
                };
                return new ScriptedConditionTokenFilter(tokenStream, filter, ScriptedConditionTokenFilterFactory.this.factory.newInstance());
            }
        };
    }

    private static class ScriptedConditionTokenFilter
    extends ConditionalTokenFilter {
        private final AnalysisPredicateScript script;
        private final AnalysisPredicateScript.Token token;

        ScriptedConditionTokenFilter(TokenStream input, Function<TokenStream, TokenStream> inputFactory, AnalysisPredicateScript script) {
            super(input, inputFactory);
            this.script = script;
            this.token = new AnalysisPredicateScript.Token((AttributeSource)this);
        }

        protected boolean shouldFilter() {
            this.token.updatePosition();
            return this.script.execute(this.token);
        }

        public void reset() throws IOException {
            super.reset();
            this.token.reset();
        }
    }
}

