/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.SingleResultDeduplicator;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.UnsafePlainActionFuture;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.MultiChunkTransfer;
import org.elasticsearch.indices.recovery.MultiFileWriter;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.CcrRequests;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkAction;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkRequest;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionRequest;

public class CcrRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(CcrRepository.class);
    public static final String LATEST = "_latest_";
    public static final String TYPE = "_ccr_";
    public static final String NAME_PREFIX = "_ccr_";
    private static final SnapshotId SNAPSHOT_ID = new SnapshotId("_latest_", "_latest_");
    private static final String IN_SYNC_ALLOCATION_ID = "ccr_restore";
    private final RepositoryMetadata metadata;
    private final CcrSettings ccrSettings;
    private final String localClusterName;
    private final String remoteClusterAlias;
    private final Client client;
    private final ThreadPool threadPool;
    private final Executor remoteClientResponseExecutor;
    private final Executor chunkResponseExecutor;
    private final CounterMetric throttledTime = new CounterMetric();
    private final SingleResultDeduplicator<ClusterState> csDeduplicator;
    private static final ShardGeneration DUMMY_GENERATION = new ShardGeneration("");

    public CcrRepository(RepositoryMetadata metadata, Client client, Settings settings, CcrSettings ccrSettings, ThreadPool threadPool) {
        this.metadata = metadata;
        this.ccrSettings = ccrSettings;
        this.localClusterName = ((ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(settings)).value();
        assert (metadata.name().startsWith("_ccr_")) : "CcrRepository metadata.name() must start with: _ccr_";
        this.remoteClusterAlias = org.elasticsearch.common.Strings.split((String)metadata.name(), (String)"_ccr_")[1];
        this.client = client;
        this.threadPool = threadPool;
        this.remoteClientResponseExecutor = threadPool.executor("ccr");
        this.chunkResponseExecutor = threadPool.generic();
        this.csDeduplicator = new SingleResultDeduplicator(threadPool.getThreadContext(), l -> this.getRemoteClusterClient().execute(ClusterStateAction.REMOTE_TYPE, (ActionRequest)new ClusterStateRequest(TimeValue.MAX_VALUE).clear().metadata(true).nodes(true), l.map(ClusterStateResponse::getState)));
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    private RemoteClusterClient getRemoteClusterClient() {
        return this.client.getRemoteClusterClient(this.remoteClusterAlias, this.remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
    }

    public void getSnapshotInfo(Collection<SnapshotId> snapshotIds, boolean abortOnFailure, BooleanSupplier isCancelled, CheckedConsumer<SnapshotInfo, Exception> consumer, ActionListener<Void> listener) {
        assert (snapshotIds.size() == 1 && SNAPSHOT_ID.equals((Object)snapshotIds.iterator().next())) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId but saw " + snapshotIds;
        try {
            this.csDeduplicator.execute((ActionListener)new ThreadedActionListener((Executor)this.threadPool.executor("snapshot_meta"), listener.map(response -> {
                Snapshot snapshot = new Snapshot(this.metadata.name(), SNAPSHOT_ID);
                IndexVersion maxIndexVersion = response.getNodes().getMaxDataNodeCompatibleIndexVersion();
                if (IndexVersion.current().equals((Object)maxIndexVersion)) {
                    for (DiscoveryNode node : response.nodes()) {
                        BuildVersion remoteVersion;
                        if (!node.canContainData() || !node.getMaxIndexVersion().equals((Object)maxIndexVersion) || !(remoteVersion = BuildVersion.fromVersionId((int)node.getVersion().id)).isFutureVersion()) continue;
                        throw new SnapshotException(snapshot, "the snapshot was created with version [" + remoteVersion + "] which is higher than the version of this node [" + Build.current().version() + "]");
                    }
                }
                Metadata responseMetadata = response.metadata();
                Map indicesMap = responseMetadata.indices();
                consumer.accept((Object)new SnapshotInfo(snapshot, List.copyOf(indicesMap.keySet()), List.copyOf(responseMetadata.dataStreams().keySet()), List.of(), maxIndexVersion, SnapshotState.SUCCESS));
                return null;
            })));
        }
        catch (Exception e) {
            assert (false) : e;
            listener.onFailure(e);
        }
    }

    private <Request extends ActionRequest, Response extends ActionResponse> Response executeRecoveryAction(RemoteClusterClient client, RemoteClusterActionType<Response> action, Request request) {
        PlainActionFuture future = new PlainActionFuture();
        client.execute(action, request, (ActionListener)future);
        return (Response)((ActionResponse)future.actionGet(this.ccrSettings.getRecoveryActionTimeout().millis(), TimeUnit.MILLISECONDS));
    }

    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        RemoteClusterClient remoteClient = this.getRemoteClusterClient();
        ClusterStateResponse clusterState = (ClusterStateResponse)this.executeRecoveryAction(remoteClient, ClusterStateAction.REMOTE_TYPE, CcrRequests.metadataRequest("dummy_index_name"));
        return clusterState.getState().metadata();
    }

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        String leaderIndex = index.getName();
        RemoteClusterClient remoteClient = this.getRemoteClusterClient();
        ClusterStateResponse clusterState = (ClusterStateResponse)this.executeRecoveryAction(remoteClient, ClusterStateAction.REMOTE_TYPE, CcrRequests.metadataRequest(leaderIndex));
        PlainActionFuture future = new PlainActionFuture();
        IndexMetadata leaderIndexMetadata = clusterState.getState().metadata().index(leaderIndex);
        CcrLicenseChecker.fetchLeaderHistoryUUIDs(remoteClient, leaderIndexMetadata, arg_0 -> ((PlainActionFuture)future).onFailure(arg_0), arg_0 -> ((PlainActionFuture)future).onResponse(arg_0));
        CharSequence[] leaderHistoryUUIDs = (String[])future.actionGet(this.ccrSettings.getRecoveryActionTimeout());
        IndexMetadata.Builder imdBuilder = IndexMetadata.builder((String)leaderIndex);
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        customMetadata.put("leader_index_shard_history_uuids", String.join((CharSequence)",", leaderHistoryUUIDs));
        customMetadata.put("leader_index_uuid", leaderIndexMetadata.getIndexUUID());
        customMetadata.put("leader_index_name", leaderIndexMetadata.getIndex().getName());
        customMetadata.put("remote_cluster_name", this.remoteClusterAlias);
        imdBuilder.putCustom("ccr", customMetadata);
        imdBuilder.settings(leaderIndexMetadata.getSettings());
        imdBuilder.putMapping(leaderIndexMetadata.mapping());
        imdBuilder.setRoutingNumShards(leaderIndexMetadata.getRoutingNumShards());
        for (Integer key : leaderIndexMetadata.getInSyncAllocationIds().keySet()) {
            imdBuilder.putInSyncAllocationIds(key.intValue(), Collections.singleton(IN_SYNC_ALLOCATION_ID));
        }
        return imdBuilder.build();
    }

    public void getRepositoryData(Executor responseExecutor, ActionListener<RepositoryData> listener) {
        try {
            this.csDeduplicator.execute((ActionListener)new ThreadedActionListener(responseExecutor, listener.map(response -> {
                Metadata remoteMetadata = response.getMetadata();
                String[] concreteAllIndices = remoteMetadata.getConcreteAllIndices();
                Map copiedSnapshotIds = Maps.newMapWithExpectedSize((int)concreteAllIndices.length);
                Map snapshotsDetails = Maps.newMapWithExpectedSize((int)concreteAllIndices.length);
                Map indexSnapshots = Maps.newMapWithExpectedSize((int)concreteAllIndices.length);
                Map remoteIndices = remoteMetadata.getIndices();
                for (String indexName : concreteAllIndices) {
                    SnapshotId snapshotId = new SnapshotId(LATEST, LATEST);
                    copiedSnapshotIds.put(indexName, snapshotId);
                    long nowMillis = this.threadPool.absoluteTimeInMillis();
                    snapshotsDetails.put(indexName, new RepositoryData.SnapshotDetails(SnapshotState.SUCCESS, IndexVersion.current(), nowMillis, nowMillis, ""));
                    indexSnapshots.put(new IndexId(indexName, ((IndexMetadata)remoteIndices.get(indexName)).getIndex().getUUID()), List.of(snapshotId));
                }
                return new RepositoryData("_na_", 1L, copiedSnapshotIds, snapshotsDetails, indexSnapshots, ShardGenerations.EMPTY, IndexMetaDataGenerations.EMPTY, "_na_");
            })));
        }
        catch (Exception e) {
            assert (false);
            listener.onFailure(e);
        }
    }

    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryDataGeneration, IndexVersion minimumNodeVersion, ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
        repositoryDataUpdateListener.onFailure((Exception)new UnsupportedOperationException("Unsupported for repository of type: _ccr_"));
    }

    public long getSnapshotThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getRestoreThrottleTimeInNanos() {
        return this.throttledTime.count();
    }

    public String startVerification() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void endVerification(String verificationToken) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void verify(String verificationToken, DiscoveryNode localNode) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void snapshotShard(SnapshotShardContext context) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void restoreShard(Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        final ShardId shardId = store.shardId();
        LinkedList toClose = new LinkedList();
        ActionListener.run(listener, restoreShardListener -> {
            ActionListener restoreListener = ActionListener.runBefore((ActionListener)restoreShardListener.delegateResponse((l, e) -> l.onFailure((Exception)new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId + "]", (Throwable)e))), () -> IOUtils.close((Iterable)toClose));
            CcrRepository.createEmptyStore(store);
            Map ccrMetadata = store.indexSettings().getIndexMetadata().getCustomData("ccr");
            String leaderIndexName = (String)ccrMetadata.get("leader_index_name");
            String leaderUUID = (String)ccrMetadata.get("leader_index_uuid");
            final Index leaderIndex = new Index(leaderIndexName, leaderUUID);
            ShardId leaderShardId = new ShardId(leaderIndex, shardId.getId());
            final RemoteClusterClient remoteClient = this.getRemoteClusterClient();
            String retentionLeaseId = CcrRetentionLeases.retentionLeaseId(this.localClusterName, shardId.getIndex(), this.remoteClusterAlias, leaderIndex);
            this.acquireRetentionLeaseOnLeader(shardId, retentionLeaseId, leaderShardId, remoteClient);
            Scheduler.Cancellable renewable = this.threadPool.scheduleWithFixedDelay(() -> {
                logger.trace("{} background renewal of retention lease [{}] during restore", (Object)shardId, (Object)retentionLeaseId);
                try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().newEmptySystemContext();){
                    CcrRetentionLeases.asyncRenewRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, (ActionListener<ActionResponse.Empty>)ActionListener.wrap(r -> {}, e -> {
                        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                        assert (!(cause instanceof ElasticsearchSecurityException)) : cause;
                        if (!(cause instanceof RetentionLeaseInvalidRetainingSeqNoException)) {
                            logger.warn(() -> Strings.format((String)"%s background renewal of retention lease [%s] failed during restore", (Object[])new Object[]{shardId, retentionLeaseId}), cause);
                        }
                    }));
                }
            }, (TimeValue)CcrRetentionLeases.RETENTION_LEASE_RENEW_INTERVAL_SETTING.get(store.indexSettings().getNodeSettings()), this.remoteClientResponseExecutor);
            toClose.add(() -> {
                logger.trace("{} canceling background renewal of retention lease [{}] at the end of restore", (Object)shardId, (Object)retentionLeaseId);
                renewable.cancel();
            });
            ActionListener sessionListener = restoreListener.delegateFailureAndWrap((l1, restoreSession) -> restoreSession.restoreFiles(store, new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    logger.trace("[{}] completed CCR restore", (Object)shardId);
                    CcrRepository.this.updateMappings(remoteClient, leaderIndex, restoreSession.mappingVersion, CcrRepository.this.client, shardId.getIndex());
                    restoreSession.close((ActionListener<Void>)l1);
                }

                public void onFailure(Exception e) {
                    restoreSession.close((ActionListener<Void>)ActionListener.running(() -> l1.onFailure(e)));
                }
            }));
            this.openSession(this.metadata.name(), remoteClient, leaderShardId, shardId, recoveryState, (ActionListener<RestoreSession>)sessionListener);
        });
    }

    private static void createEmptyStore(Store store) {
        store.incRef();
        try {
            store.createEmpty();
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(store.shardId(), "failed to create empty store", e);
        }
        finally {
            store.decRef();
        }
    }

    void acquireRetentionLeaseOnLeader(ShardId shardId, String retentionLeaseId, ShardId leaderShardId, RemoteClusterClient remoteClient) {
        logger.trace(() -> Strings.format((String)"%s requesting leader to add retention lease [%s]", (Object[])new Object[]{shardId, retentionLeaseId}));
        TimeValue timeout = this.ccrSettings.getRecoveryActionTimeout();
        Optional<RetentionLeaseAlreadyExistsException> maybeAddAlready = CcrRetentionLeases.syncAddRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
        maybeAddAlready.ifPresent(addAlready -> {
            logger.trace(() -> Strings.format((String)"%s retention lease [%s] already exists, requesting a renewal", (Object[])new Object[]{shardId, retentionLeaseId}), (Throwable)addAlready);
            Optional<RetentionLeaseNotFoundException> maybeRenewNotFound = CcrRetentionLeases.syncRenewRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
            maybeRenewNotFound.ifPresent(renewNotFound -> {
                logger.trace(() -> Strings.format((String)"%s retention lease [%s] not found while attempting to renew, requesting a final add", (Object[])new Object[]{shardId, retentionLeaseId}), (Throwable)renewNotFound);
                Optional<RetentionLeaseAlreadyExistsException> maybeFallbackAddAlready = CcrRetentionLeases.syncAddRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
                maybeFallbackAddAlready.ifPresent(fallbackAddAlready -> {
                    assert (false) : fallbackAddAlready;
                    throw fallbackAddAlready;
                });
            });
        });
    }

    public IndexShardSnapshotStatus.Copy getShardSnapshotStatus(SnapshotId snapshotId, IndexId index, ShardId shardId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        String leaderIndex = index.getName();
        IndicesStatsResponse response = (IndicesStatsResponse)this.executeRecoveryAction(this.getRemoteClusterClient(), IndicesStatsAction.REMOTE_TYPE, ((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{leaderIndex})).clear().store(true));
        for (ShardStats shardStats : response.getIndex(leaderIndex).getShards()) {
            ShardRouting shardRouting = shardStats.getShardRouting();
            if (shardRouting.shardId().id() != shardId.getId() || !shardRouting.primary() || !shardRouting.active()) continue;
            long totalSize = shardStats.getStats().getStore().sizeInBytes();
            return IndexShardSnapshotStatus.newDone((long)0L, (long)0L, (int)1, (int)1, (long)totalSize, (long)totalSize, (ShardGeneration)DUMMY_GENERATION);
        }
        throw new ElasticsearchException("Could not get shard stats for primary of index " + leaderIndex + " on leader cluster", new Object[0]);
    }

    public void updateState(ClusterState state) {
    }

    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void awaitIdle() {
    }

    private void updateMappings(RemoteClusterClient leaderClient, Index leaderIndex, long leaderMappingVersion, Client followerClient, Index followerIndex) {
        UnsafePlainActionFuture indexMetadataFuture = new UnsafePlainActionFuture(new String[]{"ccr", "generic"});
        long startTimeInNanos = System.nanoTime();
        Supplier<TimeValue> timeout = () -> {
            long elapsedInNanos = System.nanoTime() - startTimeInNanos;
            return TimeValue.timeValueNanos((long)(this.ccrSettings.getRecoveryActionTimeout().nanos() - elapsedInNanos));
        };
        CcrRequests.getIndexMetadata(leaderClient, leaderIndex, leaderMappingVersion, 0L, timeout, (ActionListener<IndexMetadata>)indexMetadataFuture);
        IndexMetadata leaderIndexMetadata = (IndexMetadata)indexMetadataFuture.actionGet(this.ccrSettings.getRecoveryActionTimeout());
        MappingMetadata mappingMetadata = leaderIndexMetadata.mapping();
        if (mappingMetadata != null) {
            PutMappingRequest putMappingRequest = CcrRequests.putMappingRequest(followerIndex.getName(), mappingMetadata);
            followerClient.admin().indices().putMapping(putMappingRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        }
    }

    void openSession(String repositoryName, RemoteClusterClient remoteClient, ShardId leaderShardId, ShardId indexShardId, RecoveryState recoveryState, ActionListener<RestoreSession> listener) {
        String sessionUUID = UUIDs.randomBase64UUID();
        ActionListener responseListener = listener.map(response -> new RestoreSession(repositoryName, this.client.getRemoteClusterClient(this.remoteClusterAlias, this.chunkResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED), sessionUUID, response.getNode(), indexShardId, recoveryState, response.getStoreFileMetadata(), response.getMappingVersion(), this.threadPool, this.chunkResponseExecutor, this.ccrSettings, arg_0 -> ((CounterMetric)this.throttledTime).inc(arg_0), leaderShardId));
        remoteClient.execute(PutCcrRestoreSessionAction.REMOTE_INTERNAL_TYPE, (ActionRequest)new PutCcrRestoreSessionRequest(sessionUUID, leaderShardId), ListenerTimeouts.wrapWithTimeout((ThreadPool)this.threadPool, (ActionListener)responseListener, (TimeValue)this.ccrSettings.getRecoveryActionTimeout(), (Executor)this.threadPool.generic(), (String)"internal:admin/ccr/restore/session/put"));
    }

    private static class RestoreSession
    extends FileRestoreContext {
        private final RemoteClusterClient remoteClient;
        private final String sessionUUID;
        private final DiscoveryNode node;
        private final Store.MetadataSnapshot sourceMetadata;
        private final long mappingVersion;
        private final CcrSettings ccrSettings;
        private final LongConsumer throttleListener;
        private final ThreadPool threadPool;
        private final Executor timeoutExecutor;
        private final ShardId leaderShardId;

        RestoreSession(String repositoryName, RemoteClusterClient remoteClient, String sessionUUID, DiscoveryNode node, ShardId shardId, RecoveryState recoveryState, Store.MetadataSnapshot sourceMetadata, long mappingVersion, ThreadPool threadPool, Executor timeoutExecutor, CcrSettings ccrSettings, LongConsumer throttleListener, ShardId leaderShardId) {
            super(repositoryName, shardId, SNAPSHOT_ID, recoveryState);
            this.remoteClient = remoteClient;
            this.sessionUUID = sessionUUID;
            this.node = node;
            this.sourceMetadata = sourceMetadata;
            this.mappingVersion = mappingVersion;
            this.threadPool = threadPool;
            this.timeoutExecutor = timeoutExecutor;
            this.ccrSettings = ccrSettings;
            this.throttleListener = throttleListener;
            this.leaderShardId = leaderShardId;
        }

        void restoreFiles(Store store, ActionListener<Void> listener) {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            for (StoreFileMetadata fileMetadata : this.sourceMetadata) {
                ByteSizeValue fileSize = ByteSizeValue.ofBytes((long)fileMetadata.length());
                fileInfos.add(new BlobStoreIndexShardSnapshot.FileInfo(fileMetadata.name(), fileMetadata, fileSize));
            }
            SnapshotFiles snapshotFiles = new SnapshotFiles(CcrRepository.LATEST, fileInfos, null);
            this.restore(snapshotFiles, store, listener);
        }

        protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, final Store store, ActionListener<Void> allFilesListener) {
            logger.trace("[{}] starting CCR restore of {} files", (Object)this.shardId, filesToRecover);
            List mds = filesToRecover.stream().map(BlobStoreIndexShardSnapshot.FileInfo::metadata).collect(Collectors.toList());
            MultiChunkTransfer<StoreFileMetadata, FileChunk> multiFileTransfer = new MultiChunkTransfer<StoreFileMetadata, FileChunk>(logger, this.threadPool.getThreadContext(), allFilesListener, this.ccrSettings.getMaxConcurrentFileChunks(), mds){
                final MultiFileWriter multiFileWriter;
                long offset;
                {
                    super(arg0, arg1, arg2, arg3, arg4);
                    this.multiFileWriter = new MultiFileWriter(store, recoveryState.getIndex(), "", logger);
                    this.offset = 0L;
                }

                protected void onNewResource(StoreFileMetadata md) {
                    this.offset = 0L;
                }

                protected FileChunk nextChunkRequest(StoreFileMetadata md) {
                    int bytesRequested = Math.toIntExact(Math.min(ccrSettings.getChunkSize().getBytes(), md.length() - this.offset));
                    this.offset += (long)bytesRequested;
                    return new FileChunk(md, bytesRequested, this.offset == md.length());
                }

                protected void executeChunkRequest(FileChunk request, ActionListener<Void> listener) {
                    remoteClient.execute(GetCcrRestoreFileChunkAction.REMOTE_INTERNAL_TYPE, (ActionRequest)new GetCcrRestoreFileChunkRequest(node, sessionUUID, request.md.name(), request.bytesRequested, leaderShardId), ListenerTimeouts.wrapWithTimeout((ThreadPool)threadPool, (ActionListener)listener.map(getCcrRestoreFileChunkResponse -> {
                        this.writeFileChunk(request.md, (GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse)((Object)getCcrRestoreFileChunkResponse));
                        return null;
                    }), (TimeValue)ccrSettings.getRecoveryActionTimeout(), (Executor)timeoutExecutor, (String)"internal:admin/ccr/restore/file_chunk/get"));
                }

                private void writeFileChunk(StoreFileMetadata md, GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse r) throws Exception {
                    assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
                    int actualChunkSize = r.getChunk().length();
                    logger.trace("[{}] [{}] got response for file [{}], offset: {}, length: {}", (Object)shardId, (Object)snapshotId, (Object)md.name(), (Object)r.getOffset(), (Object)actualChunkSize);
                    long nanosPaused = ccrSettings.getRateLimiter().maybePause(actualChunkSize);
                    throttleListener.accept(nanosPaused);
                    this.multiFileWriter.incRef();
                    try (Releasable ignored = () -> ((MultiFileWriter)this.multiFileWriter).decRef();){
                        boolean lastChunk = r.getOffset() + (long)actualChunkSize >= md.length();
                        this.multiFileWriter.writeFileChunk(md, r.getOffset(), r.getChunk(), lastChunk);
                    }
                    catch (Exception e) {
                        this.handleError(md, e);
                        throw e;
                    }
                }

                protected void handleError(StoreFileMetadata md, Exception e) throws Exception {
                    IOException corruptIndexException = ExceptionsHelper.unwrapCorruption((Throwable)e);
                    if (corruptIndexException != null) {
                        try {
                            store.markStoreCorrupted(corruptIndexException);
                        }
                        catch (IOException ioe) {
                            logger.warn("store cannot be marked as corrupted", (Throwable)e);
                        }
                        throw corruptIndexException;
                    }
                    throw e;
                }

                public void close() {
                    this.multiFileWriter.close();
                }
            };
            multiFileTransfer.start();
        }

        public void close(ActionListener<Void> listener) {
            ActionListener closeListener = ListenerTimeouts.wrapWithTimeout((ThreadPool)this.threadPool, listener, (TimeValue)this.ccrSettings.getRecoveryActionTimeout(), (Executor)this.timeoutExecutor, (String)"internal:admin/ccr/restore/session/clear");
            ClearCcrRestoreSessionRequest clearRequest = new ClearCcrRestoreSessionRequest(this.sessionUUID, this.node, this.leaderShardId);
            this.remoteClient.execute(ClearCcrRestoreSessionAction.REMOTE_INTERNAL_TYPE, (ActionRequest)clearRequest, closeListener.map(empty -> null));
        }

        private record FileChunk(StoreFileMetadata md, int bytesRequested, boolean lastChunk) implements MultiChunkTransfer.ChunkRequest
        {
        }
    }
}

