/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.DeleteAutoFollowPatternAction;

public class TransportDeleteAutoFollowPatternAction
extends AcknowledgedTransportMasterNodeAction<DeleteAutoFollowPatternAction.Request> {
    @Inject
    public TransportDeleteAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/delete", transportService, clusterService, threadPool, actionFilters, DeleteAutoFollowPatternAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, final DeleteAutoFollowPatternAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("delete-auto-follow-pattern-" + request.getName(), (ClusterStateUpdateTask)new AckedClusterStateUpdateTask((AcknowledgedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportDeleteAutoFollowPatternAction.innerDelete(request, currentState);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState innerDelete(DeleteAutoFollowPatternAction.Request request, ClusterState currentState) {
        AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metadata().custom("ccr_auto_follow");
        if (currentAutoFollowMetadata == null || currentAutoFollowMetadata.getPatterns().get(request.getName()) == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{request.getName()});
        }
        AutoFollowMetadata newAutoFollowMetadata = TransportDeleteAutoFollowPatternAction.removePattern(currentAutoFollowMetadata, request.getName());
        return currentState.copyAndUpdateMetadata(metadata -> metadata.putCustom("ccr_auto_follow", (Metadata.Custom)newAutoFollowMetadata));
    }

    private static AutoFollowMetadata removePattern(AutoFollowMetadata metadata, String name) {
        return new AutoFollowMetadata(Maps.copyMapWithRemovedEntry((Map)metadata.getPatterns(), (Object)name), Maps.copyMapWithRemovedEntry((Map)metadata.getFollowedLeaderIndexUUIDs(), (Object)name), Maps.copyMapWithRemovedEntry((Map)metadata.getHeaders(), (Object)name));
    }

    protected ClusterBlockException checkBlock(DeleteAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

