/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotRetentionConfiguration;

public class TransportSLMGetExpiredSnapshotsAction
extends TransportAction<Request, Response> {
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/slm/execute/get_expired_snapshots");
    private static final Logger logger = LogManager.getLogger(TransportSLMGetExpiredSnapshotsAction.class);
    private final RepositoriesService repositoriesService;
    private final Executor retentionExecutor;
    private static final Set<SnapshotState> RETAINABLE_STATES = EnumSet.of(SnapshotState.SUCCESS, SnapshotState.FAILED, SnapshotState.PARTIAL);

    @Inject
    public TransportSLMGetExpiredSnapshotsAction(TransportService transportService, RepositoriesService repositoriesService, ActionFilters actionFilters) {
        super(INSTANCE.name(), actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.repositoriesService = repositoriesService;
        this.retentionExecutor = transportService.getThreadPool().executor("management");
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ResultsBuilder resultsBuilder = new ResultsBuilder();
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> listener.onResponse((Object)resultsBuilder.getResponse()));){
            for (final String repositoryName : request.repositories()) {
                Repository repository;
                try {
                    repository = this.repositoriesService.repository(repositoryName);
                }
                catch (RepositoryMissingException e) {
                    logger.debug("[{}]: repository not found", (Object)repositoryName);
                    continue;
                }
                if (repository.isReadOnly()) {
                    logger.debug("[{}]: skipping readonly repository", (Object)repositoryName);
                    continue;
                }
                this.retentionExecutor.execute((Runnable)ActionRunnable.wrap((ActionListener)ActionListener.releaseAfter((ActionListener)new ActionListener<Void>(){

                    public void onResponse(Void unused) {
                    }

                    public void onFailure(Exception e) {
                        logger.debug(Strings.format((String)"[%s]: could not compute expired snapshots", (Object[])new Object[]{repositoryName}), (Throwable)e);
                    }
                }, (Releasable)refs.acquire()), perRepositoryListener -> SubscribableListener.newForked(l -> repository.getRepositoryData(this.retentionExecutor, l)).andThen((l, repositoryData) -> TransportSLMGetExpiredSnapshotsAction.getSnapshotDetailsByPolicy(this.retentionExecutor, repository, repositoryData, (ActionListener<SnapshotDetailsByPolicy>)l)).andThenAccept(snapshotDetailsByPolicy -> resultsBuilder.addResult(repositoryName, TransportSLMGetExpiredSnapshotsAction.getSnapshotsToDelete(repositoryName, request.policies(), snapshotDetailsByPolicy))).addListener(perRepositoryListener)));
            }
        }
    }

    static void getSnapshotDetailsByPolicy(Executor executor, Repository repository, RepositoryData repositoryData, ActionListener<SnapshotDetailsByPolicy> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"management"}));
        SnapshotDetailsByPolicy snapshotDetailsByPolicy = new SnapshotDetailsByPolicy();
        ArrayList<SnapshotId> snapshotsWithMissingDetails = new ArrayList<SnapshotId>();
        for (SnapshotId snapshotId : repositoryData.getSnapshotIds()) {
            if (repositoryData.hasMissingDetails(snapshotId)) {
                snapshotsWithMissingDetails.add(snapshotId);
                continue;
            }
            snapshotDetailsByPolicy.add(snapshotId, Objects.requireNonNull(repositoryData.getSnapshotDetails(snapshotId)));
        }
        if (snapshotsWithMissingDetails.isEmpty()) {
            listener.onResponse((Object)snapshotDetailsByPolicy);
        } else {
            logger.debug("[{}]: retrieving snapshot details from snapshot info for {}", (Object)repository.getMetadata().name(), snapshotsWithMissingDetails);
            repository.getSnapshotInfo(snapshotsWithMissingDetails, false, () -> false, snapshotInfo -> snapshotDetailsByPolicy.add(snapshotInfo.snapshotId(), RepositoryData.SnapshotDetails.fromSnapshotInfo((SnapshotInfo)snapshotInfo)), (ActionListener)new ThreadedActionListener(executor, listener.map(ignored -> snapshotDetailsByPolicy)));
        }
    }

    static List<Tuple<SnapshotId, String>> getSnapshotsToDelete(String repositoryName, Map<String, SnapshotLifecyclePolicy> policies, SnapshotDetailsByPolicy snapshotDetailsByPolicy) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"management"}));
        return snapshotDetailsByPolicy.flatMap((policyName, snapshotsForPolicy) -> {
            SnapshotLifecyclePolicy policy = (SnapshotLifecyclePolicy)policies.get(policyName);
            if (policy == null) {
                logger.debug("[{}]: unknown policy [{}]", (Object)repositoryName, policyName);
                return Stream.of(new Tuple[0]);
            }
            SnapshotRetentionConfiguration retention = policy.getRetentionPolicy();
            if (retention == null || retention.equals((Object)SnapshotRetentionConfiguration.EMPTY)) {
                logger.debug("[{}]: policy [{}] has no retention configuration", (Object)repositoryName, policyName);
                return Stream.of(new Tuple[0]);
            }
            if (!Objects.equals(policy.getRepository(), repositoryName)) {
                logger.debug("[{}]: policy [{}] applies to repository [{}]", (Object)repositoryName, policyName, (Object)policy.getRepository());
                return Stream.of(new Tuple[0]);
            }
            logger.trace("[{}]: policy [{}] covers [{}] snapshots", (Object)repositoryName, policyName, (Object)snapshotsForPolicy.size());
            return snapshotsForPolicy.entrySet().stream().filter(e -> {
                boolean eligibleForDeletion = retention.isSnapshotEligibleForDeletion((SnapshotId)e.getKey(), (RepositoryData.SnapshotDetails)e.getValue(), snapshotsForPolicy);
                logger.debug("[{}]: testing snapshot [{}] deletion eligibility with policy [{}]: {}", (Object)repositoryName, e.getKey(), policyName, (Object)(eligibleForDeletion ? "ELIGIBLE" : "INELIGIBLE"));
                return eligibleForDeletion;
            }).map(e -> Tuple.tuple((Object)((SnapshotId)e.getKey()), (Object)policyName));
        }).toList();
    }

    private static class ResultsBuilder {
        private final Map<String, List<Tuple<SnapshotId, String>>> resultsByRepository = ConcurrentCollections.newConcurrentMap();

        private ResultsBuilder() {
        }

        Response getResponse() {
            return new Response(Map.copyOf(this.resultsByRepository));
        }

        void addResult(String repository, List<Tuple<SnapshotId, String>> snapshotsToDelete) {
            if (snapshotsToDelete.isEmpty()) {
                assert (!this.resultsByRepository.containsKey(repository));
            } else {
                List<Tuple<SnapshotId, String>> previousValue = this.resultsByRepository.put(repository, snapshotsToDelete);
                assert (previousValue == null) : repository + ": " + previousValue + " vs " + snapshotsToDelete;
            }
        }
    }

    public static final class Request
    extends LegacyActionRequest {
        private final Collection<String> repositories;
        private final Map<String, SnapshotLifecyclePolicy> policies;

        public Request(Collection<String> repositories, Map<String, SnapshotLifecyclePolicy> policies) {
            this.repositories = repositories;
            this.policies = policies;
        }

        public Collection<String> repositories() {
            return this.repositories;
        }

        public Map<String, SnapshotLifecyclePolicy> policies() {
            return this.policies;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) {
            TransportAction.localOnly();
        }
    }

    static class SnapshotDetailsByPolicy {
        private final Map<String, Map<SnapshotId, RepositoryData.SnapshotDetails>> snapshotsByPolicy = new HashMap<String, Map<SnapshotId, RepositoryData.SnapshotDetails>>();

        SnapshotDetailsByPolicy() {
        }

        synchronized void add(SnapshotId snapshotId, RepositoryData.SnapshotDetails snapshotDetails) {
            assert (RETAINABLE_STATES.contains(snapshotDetails.getSnapshotState()));
            String slmPolicy = snapshotDetails.getSlmPolicy();
            if (Strings.hasLength((String)slmPolicy)) {
                this.snapshotsByPolicy.computeIfAbsent(slmPolicy, ignored -> new HashMap()).put(snapshotId, snapshotDetails);
            }
        }

        <T> Stream<T> flatMap(BiFunction<String, Map<SnapshotId, RepositoryData.SnapshotDetails>, Stream<T>> fn) {
            return this.snapshotsByPolicy.entrySet().stream().flatMap((? super T entry) -> (Stream)fn.apply((String)entry.getKey(), (Map)entry.getValue()));
        }
    }

    public static final class Response
    extends ActionResponse {
        private final Map<String, List<Tuple<SnapshotId, String>>> snapshotsToDelete;

        public Response(Map<String, List<Tuple<SnapshotId, String>>> snapshotsToDelete) {
            this.snapshotsToDelete = snapshotsToDelete;
        }

        public Map<String, List<Tuple<SnapshotId, String>>> snapshotsToDelete() {
            return this.snapshotsToDelete;
        }

        public void writeTo(StreamOutput out) {
            TransportAction.localOnly();
        }
    }
}

