/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;

public class ClusterStatsMonitoringDoc
extends MonitoringDoc {
    private static final ToXContent.MapParams CLUSTER_STATS_PARAMS = new ToXContent.MapParams(Collections.singletonMap("metric", ClusterState.Metric.VERSION + "," + ClusterState.Metric.MASTER_NODE + "," + ClusterState.Metric.NODES));
    public static final String TYPE = "cluster_stats";
    protected static final String SETTING_DISPLAY_NAME = "cluster.metadata.display_name";
    private final String clusterName;
    private final String version;
    private final License license;
    private final boolean apmIndicesExist;
    private final List<XPackFeatureUsage> usages;
    private final ClusterStatsResponse clusterStats;
    private final ClusterState clusterState;
    private final ClusterHealthStatus status;
    private final boolean clusterNeedsTLSEnabled;

    ClusterStatsMonitoringDoc(String cluster, long timestamp, long intervalMillis, MonitoringDoc.Node node, String clusterName, String version, ClusterHealthStatus status, @Nullable License license, boolean apmIndicesExist, @Nullable List<XPackFeatureUsage> usages, @Nullable ClusterStatsResponse clusterStats, @Nullable ClusterState clusterState, boolean clusterNeedsTLSEnabled) {
        super(cluster, timestamp, intervalMillis, node, MonitoredSystem.ES, TYPE, null);
        this.clusterName = Objects.requireNonNull(clusterName);
        this.version = Objects.requireNonNull(version);
        this.status = Objects.requireNonNull(status);
        this.license = license;
        this.apmIndicesExist = apmIndicesExist;
        this.usages = usages;
        this.clusterStats = clusterStats;
        this.clusterState = clusterState;
        this.clusterNeedsTLSEnabled = clusterNeedsTLSEnabled;
    }

    String getClusterName() {
        return this.clusterName;
    }

    String getVersion() {
        return this.version;
    }

    License getLicense() {
        return this.license;
    }

    boolean getAPMIndicesExist() {
        return this.apmIndicesExist;
    }

    List<XPackFeatureUsage> getUsages() {
        return this.usages;
    }

    ClusterStatsResponse getClusterStats() {
        return this.clusterStats;
    }

    ClusterState getClusterState() {
        return this.clusterState;
    }

    ClusterHealthStatus getStatus() {
        return this.status;
    }

    boolean getClusterNeedsTLSEnabled() {
        return this.clusterNeedsTLSEnabled;
    }

    String getClusterDisplayName() {
        Metadata metadata = this.clusterState.getMetadata();
        if (metadata == null) {
            return null;
        }
        return metadata.settings().get(SETTING_DISPLAY_NAME);
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String displayName;
        builder.field("cluster_name", this.clusterName);
        builder.field("version", this.version);
        if (this.license != null) {
            builder.startObject("license");
            Map<String, String> extraParams = Map.of("rest_view", "true");
            params = new ToXContent.DelegatingMapParams(extraParams, params);
            this.license.toInnerXContent(builder, params);
            if (this.clusterNeedsTLSEnabled) {
                builder.field("cluster_needs_tls", true);
            }
            builder.endObject();
        }
        if (this.clusterStats != null) {
            builder.startObject(TYPE);
            this.clusterStats.toXContent(builder, params);
            builder.endObject();
        }
        if (this.clusterState != null) {
            builder.startObject("cluster_state");
            builder.field("nodes_hash", ClusterStatsMonitoringDoc.nodesHash(this.clusterState.nodes()));
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
            ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this.clusterState).toXContent(builder, (ToXContent.Params)CLUSTER_STATS_PARAMS);
            builder.endObject();
        }
        if ((displayName = this.getClusterDisplayName()) != null) {
            builder.startObject("cluster_settings");
            builder.startObject("cluster");
            builder.startObject("metadata");
            builder.field("display_name", displayName);
            builder.endObject();
            builder.endObject();
            builder.endObject();
        }
        builder.startObject("stack_stats");
        builder.startObject("apm");
        builder.field("found", this.apmIndicesExist);
        builder.endObject();
        if (this.usages != null) {
            builder.startObject("xpack");
            for (XPackFeatureUsage usage : this.usages) {
                builder.field(usage.name(), (ToXContent)usage);
            }
            builder.endObject();
        }
        builder.endObject();
    }

    public static int nodesHash(DiscoveryNodes nodes) {
        StringBuilder temp = new StringBuilder();
        for (DiscoveryNode node : nodes) {
            temp.append(node.getEphemeralId());
        }
        return temp.toString().hashCode();
    }
}

