/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.rate.RateAggregatorFactory;
import org.elasticsearch.xpack.analytics.rate.RateAggregatorSupplier;
import org.elasticsearch.xpack.analytics.rate.RateMode;

public class RateAggregationBuilder
extends ValuesSourceAggregationBuilder.SingleMetricAggregationBuilder<RateAggregationBuilder> {
    public static final String NAME = "rate";
    public static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    public static final ParseField MODE_FIELD = new ParseField("mode", new String[0]);
    public static final ValuesSourceRegistry.RegistryKey<RateAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("rate", RateAggregatorSupplier.class);
    public static final ObjectParser<RateAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"rate", RateAggregationBuilder::new);
    Rounding.DateTimeUnit rateUnit;
    RateMode rateMode;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        RateAggregatorFactory.registerAggregators(builder);
    }

    public RateAggregationBuilder(String name) {
        super(name);
    }

    protected RateAggregationBuilder(RateAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder.LeafOnly)clone, factoriesBuilder, metadata);
        this.rateUnit = clone.rateUnit;
        this.rateMode = clone.rateMode;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new RateAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public boolean supportsSampling() {
        return true;
    }

    public RateAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        byte b = in.readByte();
        this.rateUnit = b > 0 ? Rounding.DateTimeUnit.resolve((byte)b) : null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0) && in.readBoolean()) {
            this.rateMode = (RateMode)in.readEnum(RateMode.class);
        }
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        if (this.rateUnit != null) {
            out.writeByte(this.rateUnit.getId());
        } else {
            out.writeByte((byte)0);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_11_0)) {
            if (this.rateMode != null) {
                out.writeBoolean(true);
                out.writeEnum((Enum)this.rateMode);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    protected RateAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        if (this.field() == null && this.script() == null && this.rateMode != null) {
            throw new IllegalArgumentException("The mode parameter is only supported with field or script");
        }
        RateAggregatorSupplier aggregatorSupplier = (RateAggregatorSupplier)context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        return new RateAggregatorFactory(this.name, config, this.rateUnit, this.rateMode, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.rateUnit != null) {
            builder.field(UNIT_FIELD.getPreferredName(), this.rateUnit.shortName());
        }
        if (this.rateMode != null) {
            builder.field(MODE_FIELD.getPreferredName(), this.rateMode.value());
        }
        return builder;
    }

    public String getType() {
        return NAME;
    }

    public RateAggregationBuilder rateUnit(String rateUnit) {
        return this.rateUnit(RateAggregationBuilder.parse(rateUnit));
    }

    public RateAggregationBuilder rateUnit(Rounding.DateTimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public RateAggregationBuilder rateMode(String rateMode) {
        return this.rateMode(RateMode.resolve(rateMode));
    }

    public RateAggregationBuilder rateMode(RateMode rateMode) {
        this.rateMode = rateMode;
        return this;
    }

    static Rounding.DateTimeUnit parse(String rateUnit) {
        Rounding.DateTimeUnit parsedRate = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(rateUnit);
        if (parsedRate == null) {
            throw new IllegalArgumentException("Unsupported unit " + rateUnit);
        }
        return parsedRate;
    }

    protected ValuesSourceConfig resolveConfig(AggregationContext context) {
        if (this.field() == null && this.script() == null) {
            return new ValuesSourceConfig((ValuesSourceType)CoreValuesSourceType.NUMERIC, null, true, null, null, (Object)1.0, DocValueFormat.RAW, () -> ((AggregationContext)context).nowInMillis());
        }
        return super.resolveConfig(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RateAggregationBuilder that = (RateAggregationBuilder)((Object)o);
        return this.rateUnit == that.rateUnit && this.rateMode == that.rateMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rateUnit, this.rateMode});
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_10_0;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        PARSER.declareString(RateAggregationBuilder::rateUnit, UNIT_FIELD);
        PARSER.declareString(RateAggregationBuilder::rateMode, MODE_FIELD);
    }
}

