/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class TermQuery
extends Query {
    private final String term;
    private final Object value;
    private final boolean caseInsensitive;
    private final boolean scorable;

    public TermQuery(Source source, String term, Object value) {
        this(source, term, value, false);
    }

    public TermQuery(Source source, String term, Object value, boolean caseInsensitive) {
        this(source, term, value, caseInsensitive, false);
    }

    public TermQuery(Source source, String term, Object value, boolean caseInsensitive, boolean scorable) {
        super(source);
        this.term = term;
        this.value = value;
        this.caseInsensitive = caseInsensitive;
        this.scorable = scorable;
    }

    public String term() {
        return this.term;
    }

    public Object value() {
        return this.value;
    }

    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    protected QueryBuilder asBuilder() {
        TermQueryBuilder qb = QueryBuilders.termQuery((String)this.term, (Object)this.value);
        return !this.caseInsensitive ? qb : qb.caseInsensitive(this.caseInsensitive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term, this.value, this.caseInsensitive, this.scorable);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermQuery other = (TermQuery)obj;
        return Objects.equals(this.term, other.term) && Objects.equals(this.value, other.value) && Objects.equals(this.caseInsensitive, other.caseInsensitive) && this.scorable == other.scorable;
    }

    @Override
    protected String innerToString() {
        return this.term + ":" + this.value;
    }

    @Override
    public boolean scorable() {
        return this.scorable;
    }

    @Override
    public boolean containsPlan() {
        return false;
    }
}

