/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class QueryStringQuery
extends Query {
    private static final Map<String, BiConsumer<QueryStringQueryBuilder, Object>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(QueryStringQueryBuilder.ALLOW_LEADING_WILDCARD_FIELD.getPreferredName(), (qb, obj) -> qb.allowLeadingWildcard((Boolean)obj)), Map.entry(QueryStringQueryBuilder.ANALYZE_WILDCARD_FIELD.getPreferredName(), (qb, obj) -> qb.analyzeWildcard((Boolean)obj)), Map.entry(QueryStringQueryBuilder.ANALYZER_FIELD.getPreferredName(), (qb, obj) -> qb.analyzer((String)obj)), Map.entry(QueryStringQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), (qb, obj) -> qb.autoGenerateSynonymsPhraseQuery(((Boolean)obj).booleanValue())), Map.entry(QueryStringQueryBuilder.DEFAULT_FIELD_FIELD.getPreferredName(), (qb, obj) -> qb.defaultField((String)obj)), Map.entry(QueryStringQueryBuilder.DEFAULT_OPERATOR_FIELD.getPreferredName(), (qb, obj) -> qb.defaultOperator(Operator.fromString((String)((String)obj)))), Map.entry(QueryStringQueryBuilder.ENABLE_POSITION_INCREMENTS_FIELD.getPreferredName(), (qb, obj) -> qb.enablePositionIncrements(((Boolean)obj).booleanValue())), Map.entry(QueryStringQueryBuilder.ESCAPE_FIELD.getPreferredName(), (qb, obj) -> qb.escape(((Boolean)obj).booleanValue())), Map.entry(QueryStringQueryBuilder.FUZZINESS_FIELD.getPreferredName(), (qb, obj) -> qb.fuzziness(Fuzziness.fromString((String)((String)obj)))), Map.entry(QueryStringQueryBuilder.FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), (qb, obj) -> qb.fuzzyMaxExpansions(((Integer)obj).intValue())), Map.entry(QueryStringQueryBuilder.FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), (qb, obj) -> qb.fuzzyPrefixLength(((Integer)obj).intValue())), Map.entry(QueryStringQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), (qb, obj) -> qb.fuzzyRewrite((String)obj)), Map.entry(QueryStringQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), (qb, obj) -> qb.fuzzyTranspositions(((Boolean)obj).booleanValue())), Map.entry(QueryStringQueryBuilder.LENIENT_FIELD.getPreferredName(), (qb, obj) -> qb.lenient((Boolean)obj)), Map.entry(QueryStringQueryBuilder.MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), (qb, obj) -> qb.maxDeterminizedStates(((Integer)obj).intValue())), Map.entry(QueryStringQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), (qb, obj) -> qb.minimumShouldMatch((String)obj)), Map.entry(QueryStringQueryBuilder.PHRASE_SLOP_FIELD.getPreferredName(), (qb, obj) -> qb.phraseSlop(((Integer)obj).intValue())), Map.entry(QueryStringQueryBuilder.REWRITE_FIELD.getPreferredName(), (qb, obj) -> qb.rewrite((String)obj)), Map.entry(QueryStringQueryBuilder.QUOTE_ANALYZER_FIELD.getPreferredName(), (qb, obj) -> qb.quoteAnalyzer((String)obj)), Map.entry(QueryStringQueryBuilder.QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), (qb, obj) -> qb.quoteFieldSuffix((String)obj)), Map.entry(QueryStringQueryBuilder.TIE_BREAKER_FIELD.getPreferredName(), (qb, obj) -> qb.tieBreaker(((Float)obj).floatValue())), Map.entry(QueryStringQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), (qb, obj) -> qb.timeZone((String)obj)), Map.entry(QueryStringQueryBuilder.TYPE_FIELD.getPreferredName(), (qb, obj) -> qb.type(MultiMatchQueryBuilder.Type.parse((String)((String)obj), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE))));
    private final String query;
    private final Map<String, Float> fields;
    private final Map<String, Object> options;

    public QueryStringQuery(Source source, String query, Map<String, Float> fields, Map<String, Object> options) {
        super(source);
        this.query = query;
        this.fields = fields;
        this.options = options == null ? Collections.emptyMap() : options;
    }

    @Override
    protected QueryBuilder asBuilder() {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)this.query);
        queryBuilder.fields(this.fields);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal query_string option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, v);
        });
        return queryBuilder;
    }

    public Map<String, Float> fields() {
        return this.fields;
    }

    public String query() {
        return this.query;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.fields);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryStringQuery other = (QueryStringQuery)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.fields, other.fields) && Objects.equals(this.options, other.options);
    }

    @Override
    protected String innerToString() {
        return this.fields + ":" + this.query;
    }

    @Override
    public boolean scorable() {
        return true;
    }

    @Override
    public boolean containsPlan() {
        return false;
    }
}

