/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class NamedExpression
extends Expression
implements NamedWriteable {
    private final String name;
    private final NameId id;
    private final boolean synthetic;

    public NamedExpression(Source source, String name, List<Expression> children, @Nullable NameId id) {
        this(source, name, children, id, false);
    }

    public NamedExpression(Source source, String name, List<Expression> children, @Nullable NameId id, boolean synthetic) {
        super(source, children);
        this.name = name;
        this.id = id == null ? new NameId() : id;
        this.synthetic = synthetic;
    }

    public String name() {
        return this.name;
    }

    public NameId id() {
        return this.id;
    }

    public boolean synthetic() {
        return this.synthetic;
    }

    public abstract Attribute toAttribute();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.synthetic);
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.innerEquals(o);
    }

    protected boolean innerEquals(Object o) {
        NamedExpression other = (NamedExpression)o;
        return this.synthetic == other.synthetic && Objects.equals(this.name, other.name) && Objects.equals(this.children(), other.children());
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.id();
    }

    @Override
    public String nodeString() {
        return this.name();
    }
}

