/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class MetadataAttribute
extends TypedAttribute {
    public static final String TIMESTAMP_FIELD = "@timestamp";
    public static final String TSID_FIELD = "_tsid";
    public static final String SCORE = "_score";
    public static final String INDEX = "_index";
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "MetadataAttribute", MetadataAttribute::readFrom);
    private static final Map<String, MetadataAttributeConfiguration> ATTRIBUTES_MAP = Map.ofEntries(Map.entry("_version", new MetadataAttributeConfiguration(DataType.LONG, false)), Map.entry("_index", new MetadataAttributeConfiguration(DataType.KEYWORD, true)), Map.entry("_id", new MetadataAttributeConfiguration(DataType.KEYWORD, false)), Map.entry("_ignored", new MetadataAttributeConfiguration(DataType.KEYWORD, true)), Map.entry("_source", new MetadataAttributeConfiguration(DataType.SOURCE, false)), Map.entry("_index_mode", new MetadataAttributeConfiguration(DataType.KEYWORD, true)), Map.entry("_score", new MetadataAttributeConfiguration(DataType.DOUBLE, false)));
    private final boolean searchable;

    public MetadataAttribute(Source source, String name, DataType dataType, Nullability nullability, @Nullable NameId id, boolean synthetic, boolean searchable) {
        super(source, name, dataType, nullability, id, synthetic);
        this.searchable = searchable;
    }

    public MetadataAttribute(Source source, String name, DataType dataType, boolean searchable) {
        this(source, name, dataType, Nullability.TRUE, null, false, searchable);
    }

    @Deprecated
    private MetadataAttribute(Source source, String name, DataType dataType, @Nullable String qualifier, Nullability nullability, @Nullable NameId id, boolean synthetic, boolean searchable) {
        this(source, name, dataType, nullability, id, synthetic, searchable);
    }

    private MetadataAttribute(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), in.readString(), DataType.readFrom(in), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), NameId.readFrom((StreamInput)((PlanStreamInput)in)), in.readBoolean(), in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader(this)) {
            Source.EMPTY.writeTo(out);
            out.writeString(this.name());
            this.dataType().writeTo(out);
            out.writeOptionalString(null);
            out.writeEnum((Enum)this.nullable());
            this.id().writeTo(out);
            out.writeBoolean(this.synthetic());
            out.writeBoolean(this.searchable);
        }
    }

    public static MetadataAttribute readFrom(StreamInput in) throws IOException {
        return (MetadataAttribute)((PlanStreamInput)in).readAttributeWithCache(MetadataAttribute::new);
    }

    public String getWriteableName() {
        return MetadataAttribute.ENTRY.name;
    }

    @Override
    protected MetadataAttribute clone(Source source, String name, DataType type, Nullability nullability, NameId id, boolean synthetic) {
        return new MetadataAttribute(source, name, type, null, nullability, id, synthetic, this.searchable);
    }

    @Override
    protected String label() {
        return "m";
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MetadataAttribute::new, this.name(), this.dataType(), this.nullable(), this.id(), this.synthetic(), this.searchable);
    }

    public boolean searchable() {
        return this.searchable;
    }

    public static MetadataAttribute create(Source source, String name) {
        MetadataAttributeConfiguration t = ATTRIBUTES_MAP.get(name);
        return t != null ? new MetadataAttribute(source, name, t.dataType(), t.searchable()) : null;
    }

    public static DataType dataType(String name) {
        MetadataAttributeConfiguration t = ATTRIBUTES_MAP.get(name);
        return t != null ? t.dataType() : null;
    }

    public static boolean isSupported(String name) {
        return ATTRIBUTES_MAP.containsKey(name);
    }

    public static boolean isScoreAttribute(Expression a) {
        MetadataAttribute ma;
        return a instanceof MetadataAttribute && (ma = (MetadataAttribute)a).name().equals(SCORE);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.searchable);
    }

    @Override
    protected boolean innerEquals(Object o) {
        MetadataAttribute other = (MetadataAttribute)o;
        return super.innerEquals(other) && this.searchable == other.searchable;
    }

    private record MetadataAttributeConfiguration(DataType dataType, boolean searchable) {
    }
}

