/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.elasticsearch.repositories.s3.S3BlobContainer;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3RepositoriesMetrics;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.SnapshotsServiceUtils;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.xcontent.NamedXContentRegistry;

class S3Repository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(S3Repository.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());
    static final String TYPE = "s3";
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.insecureString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.insecureString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = ByteSizeValue.ofBytes((long)Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)));
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_FILE_SIZE_USING_MULTIPART, (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)MAX_FILE_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> MAX_MULTIPART_PARTS = Setting.intSetting((String)"max_multipart_parts", (int)10000, (int)1, (int)10000, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<TimeValue> COOLDOWN_PERIOD = Setting.timeSetting((String)"cooldown_period", (TimeValue)new TimeValue(3L, TimeUnit.MINUTES), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> DELETION_BATCH_SIZE_SETTING = Setting.intSetting((String)"delete_objects_max_size", (int)1000, (int)1, (int)1000, (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> MAX_MULTIPART_UPLOAD_CLEANUP_SIZE = Setting.intSetting((String)"max_multipart_upload_cleanup_size", (int)1000, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic});
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final ByteSizeValue chunkSize;
    private final boolean serverSideEncryption;
    private final String storageClass;
    private final String cannedACL;
    private final TimeValue coolDown;
    private final Executor snapshotExecutor;
    private final S3RepositoriesMetrics s3RepositoriesMetrics;
    static final String INSECURE_CREDENTIALS_DEPRECATION_WARNING = Strings.format((String)"This repository's settings include a S3 access key and secret key, but repository settings are stored in plaintext and must not be used for security-sensitive information. Instead, store all secure settings in the keystore. See [%s] for more information.", (Object[])new Object[]{ReferenceDocs.SECURE_SETTINGS});
    private final AtomicReference<Scheduler.Cancellable> finalizationFuture = new AtomicReference();
    private final AtomicBoolean multipartCleanupInProgress = new AtomicBoolean();

    S3Repository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, S3Service service, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, S3RepositoriesMetrics s3RepositoriesMetrics) {
        super(metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, S3Repository.buildBasePath(metadata), S3Repository.buildLocation(metadata));
        this.service = service;
        this.s3RepositoriesMetrics = s3RepositoriesMetrics;
        this.snapshotExecutor = this.threadPool().executor("snapshot");
        this.bucket = (String)BUCKET_SETTING.get(metadata.settings());
        if (!Strings.hasLength((String)this.bucket)) {
            throw new IllegalArgumentException("Invalid S3 bucket name, cannot be null or empty");
        }
        this.bufferSize = (ByteSizeValue)BUFFER_SIZE_SETTING.get(metadata.settings());
        ByteSizeValue maxChunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(metadata.settings());
        Integer maxPartsNum = (Integer)MAX_MULTIPART_PARTS.get(metadata.settings());
        this.chunkSize = S3Repository.objectSizeLimit(maxChunkSize, this.bufferSize, maxPartsNum);
        if (this.chunkSize.getBytes() < this.bufferSize.getBytes()) {
            throw new RepositoryException(metadata.name(), CHUNK_SIZE_SETTING.getKey() + " (" + this.chunkSize + ") can't be lower than " + BUFFER_SIZE_SETTING.getKey() + " (" + this.bufferSize + ").", new Object[0]);
        }
        this.serverSideEncryption = (Boolean)SERVER_SIDE_ENCRYPTION_SETTING.get(metadata.settings());
        this.storageClass = (String)STORAGE_CLASS_SETTING.get(metadata.settings());
        this.cannedACL = (String)CANNED_ACL_SETTING.get(metadata.settings());
        if (S3ClientSettings.checkDeprecatedCredentials(metadata.settings())) {
            deprecationLogger.critical(DeprecationCategory.SECURITY, "s3_repository_secret_settings", INSECURE_CREDENTIALS_DEPRECATION_WARNING, new Object[0]);
        }
        this.coolDown = (TimeValue)COOLDOWN_PERIOD.get(metadata.settings());
        logger.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)BASE_PATH_SETTING.get(metadata.settings()), "bucket", (String)BUCKET_SETTING.get(metadata.settings()));
    }

    private static ByteSizeValue objectSizeLimit(ByteSizeValue chunkSize, ByteSizeValue bufferSize, int maxPartsNum) {
        long bytes = Math.min(chunkSize.getBytes(), bufferSize.getBytes() * (long)maxPartsNum);
        return ByteSizeValue.ofBytes((long)bytes);
    }

    public void finalizeSnapshot(final FinalizeSnapshotContext finalizeSnapshotContext) {
        FinalizeSnapshotContext wrappedFinalizeContext;
        if (!SnapshotsServiceUtils.useShardGenerations((IndexVersion)finalizeSnapshotContext.repositoryMetaVersion())) {
            ListenableFuture metadataDone = new ListenableFuture();
            wrappedFinalizeContext = new FinalizeSnapshotContext(finalizeSnapshotContext.updatedShardGenerations(), finalizeSnapshotContext.repositoryStateId(), finalizeSnapshotContext.clusterMetadata(), finalizeSnapshotContext.snapshotInfo(), finalizeSnapshotContext.repositoryMetaVersion(), this.wrapWithWeakConsistencyProtection((ActionListener<RepositoryData>)ActionListener.runAfter((ActionListener)finalizeSnapshotContext, () -> metadataDone.onResponse(null))), () -> metadataDone.addListener((ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    finalizeSnapshotContext.onDone();
                }

                public void onFailure(Exception e) {
                    assert (false) : e;
                }
            }));
        } else {
            wrappedFinalizeContext = finalizeSnapshotContext;
        }
        super.finalizeSnapshot(wrappedFinalizeContext);
    }

    protected ActionListener<RepositoryData> wrapWithWeakConsistencyProtection(ActionListener<RepositoryData> listener) {
        final ActionListener wrappedListener = ActionListener.runBefore(listener, () -> {
            Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
            assert (cancellable != null);
        });
        return new ActionListener<RepositoryData>(){

            public void onResponse(RepositoryData response) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onResponse((Object)response)), S3Repository.this.coolDown, S3Repository.this.snapshotExecutor));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }

            public void onFailure(Exception e) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onFailure(e)), S3Repository.this.coolDown, S3Repository.this.snapshotExecutor));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }
        };
    }

    private void logCooldownInfo() {
        logger.info("Sleeping for [{}] after modifying repository [{}] because it contains snapshots older than version [{}] and therefore is using a backwards compatible metadata format that requires this cooldown period to avoid repository corruption. To get rid of this message and move to the new repository metadata format, either remove all snapshots older than version [{}] from the repository or create a new repository at an empty location.", (Object)this.coolDown, (Object)this.metadata.name(), (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION, (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = (String)BASE_PATH_SETTING.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            return BlobPath.EMPTY.add(basePath);
        }
        return BlobPath.EMPTY;
    }

    protected S3BlobStore createBlobStore() {
        return new S3BlobStore(this.service, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass, this.metadata, this.bigArrays, this.threadPool, this.s3RepositoriesMetrics);
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    protected void doClose() {
        Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
        if (cancellable != null) {
            logger.debug("Repository [{}] closed during cool-down period", (Object)this.metadata.name());
            cancellable.cancel();
        }
        super.doClose();
    }

    public String getAnalysisFailureExtraDetail() {
        return Strings.format((String)"Elasticsearch observed the storage system underneath this repository behaved incorrectly which indicates it is not suitable for use with Elasticsearch snapshots. Typically this happens when using storage other than AWS S3 which incorrectly claims to be S3-compatible. If so, please report this incompatibility to your storage supplier. Do not report Elasticsearch issues involving storage systems which claim to be S3-compatible unless you can demonstrate that the same issue exists when using a genuine AWS S3 repository. See [%s] for further information about repository analysis, and [%s] for further information about support for S3-compatible repository implementations.", (Object[])new Object[]{ReferenceDocs.SNAPSHOT_REPOSITORY_ANALYSIS, ReferenceDocs.S3_COMPATIBLE_REPOSITORIES});
    }

    public void deleteSnapshots(final Collection<SnapshotId> snapshotIds, final long repositoryDataGeneration, final IndexVersion minimumNodeVersion, final ActionListener<RepositoryData> repositoryDataUpdateListener, final Runnable onCompletion) {
        this.getMultipartUploadCleanupListener(this.isReadOnly() ? 0 : (Integer)MAX_MULTIPART_UPLOAD_CLEANUP_SIZE.get(this.getMetadata().settings()), new ActionListener<ActionListener<Void>>(){

            public void onResponse(final ActionListener<Void> multipartUploadCleanupListener) {
                S3Repository.super.deleteSnapshots(snapshotIds, repositoryDataGeneration, minimumNodeVersion, (ActionListener)new ActionListener<RepositoryData>(){

                    public void onResponse(RepositoryData repositoryData) {
                        multipartUploadCleanupListener.onResponse(null);
                        repositoryDataUpdateListener.onResponse((Object)repositoryData);
                    }

                    public void onFailure(Exception e) {
                        multipartUploadCleanupListener.onFailure(e);
                        repositoryDataUpdateListener.onFailure(e);
                    }
                }, onCompletion);
            }

            public void onFailure(Exception e) {
                logger.warn("failed to get multipart uploads for cleanup during snapshot delete", (Throwable)e);
                assert (false) : e;
                repositoryDataUpdateListener.onFailure(e);
            }
        });
    }

    void getMultipartUploadCleanupListener(int maxUploads, ActionListener<ActionListener<Void>> listener) {
        if (maxUploads == 0) {
            listener.onResponse((Object)ActionListener.noop());
            return;
        }
        if (!this.multipartCleanupInProgress.compareAndSet(false, true)) {
            logger.info("multipart upload cleanup already in progress");
            listener.onResponse((Object)ActionListener.noop());
            return;
        }
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> this.multipartCleanupInProgress.set(false));){
            this.snapshotExecutor.execute((Runnable)ActionRunnable.supply((ActionListener)ActionListener.releaseAfter(listener, (Releasable)refs.acquire()), () -> {
                ActionListener<Void> actionListener;
                BlobContainer patt24127$temp = this.blobContainer();
                if (patt24127$temp instanceof S3BlobContainer) {
                    S3BlobContainer s3BlobContainer = (S3BlobContainer)patt24127$temp;
                    actionListener = s3BlobContainer.getMultipartUploadCleanupListener(maxUploads, refs);
                } else {
                    actionListener = ActionListener.noop();
                }
                return actionListener;
            }));
        }
    }
}

