/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;

class RegionFromEndpointGuesser {
    private static final Map<String, String> regionsByEndpoint;

    RegionFromEndpointGuesser() {
    }

    @SuppressForbidden(reason="reads resource from jar")
    private static InputStream readFromJarResourceUrl(URL source) throws IOException {
        if (source == null) {
            throw new FileNotFoundException("links resource not found at [" + source + "]");
        }
        return source.openStream();
    }

    @Nullable
    static String guessRegion(@Nullable String endpoint) {
        if (endpoint == null) {
            return null;
        }
        if (endpoint.startsWith("https://")) {
            endpoint = endpoint.substring("https://".length());
        }
        return regionsByEndpoint.get(endpoint);
    }

    static {
        try (InputStream resourceStream = RegionFromEndpointGuesser.readFromJarResourceUrl(RegionFromEndpointGuesser.class.getResource("regions_by_endpoint.txt"));
             BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
            String line;
            HashMap<String, String> builder = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(" +");
                if (parts.length != 2) {
                    throw new IllegalStateException("invalid regions_by_endpoint.txt line: " + line);
                }
                builder.put(parts[1], parts[0]);
            }
            regionsByEndpoint = Map.copyOf(builder);
        }
        catch (Exception e) {
            assert (false) : e;
            throw new IllegalStateException("could not read regions_by_endpoint.txt", e);
        }
    }
}

