/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.ssl.SslConfigurationKeys;
import org.elasticsearch.common.ssl.SslConfigurationLoader;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

public class ReindexSslConfig {
    private static final Map<String, Setting<?>> SETTINGS;
    private static final Map<String, Setting<SecureString>> SECURE_SETTINGS;
    private final SslConfiguration configuration;
    private volatile SSLContext context;

    public static List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SETTINGS.values());
        settings.addAll(SECURE_SETTINGS.values());
        return settings;
    }

    public ReindexSslConfig(final Settings settings, Environment environment, ResourceWatcherService resourceWatcher) {
        SslConfigurationLoader loader = new SslConfigurationLoader("reindex.ssl."){

            protected boolean hasSettings(String prefix) {
                return !settings.getAsSettings(prefix).isEmpty();
            }

            protected String getSettingAsString(String key) {
                return settings.get(key);
            }

            protected char[] getSecureSetting(String key) {
                Setting<SecureString> setting = SECURE_SETTINGS.get(key);
                if (setting == null) {
                    throw new IllegalArgumentException("The secure setting [" + key + "] is not registered");
                }
                return ((SecureString)setting.get(settings)).getChars();
            }

            protected List<String> getSettingAsList(String key) throws Exception {
                return settings.getAsList(key);
            }
        };
        this.configuration = loader.load(environment.configDir());
        this.reload();
        FileChangesListener listener = new FileChangesListener(){

            public void onFileCreated(Path file) {
                this.onFileChanged(file);
            }

            public void onFileDeleted(Path file) {
                this.onFileChanged(file);
            }

            public void onFileChanged(Path file) {
                ReindexSslConfig.this.reload();
            }
        };
        for (Path file : this.configuration.getDependentFiles()) {
            try {
                FileWatcher watcher = new FileWatcher(file);
                watcher.addListener((Object)listener);
                resourceWatcher.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
            }
            catch (IOException e) {
                throw new UncheckedIOException("cannot watch file [" + file + "]", e);
            }
        }
    }

    private void reload() {
        this.context = this.configuration.createSslContext();
    }

    SSLIOSessionStrategy getStrategy() {
        DefaultHostnameVerifier hostnameVerifier = this.configuration.verificationMode().isHostnameVerificationEnabled() ? new DefaultHostnameVerifier() : new NoopHostnameVerifier();
        String[] protocols = this.configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        String[] cipherSuites = this.configuration.getCipherSuites().toArray(Strings.EMPTY_ARRAY);
        return new SSLIOSessionStrategy(this.context, protocols, cipherSuites, (HostnameVerifier)hostnameVerifier);
    }

    static {
        Setting.Property[] properties;
        String settingName;
        SETTINGS = new HashMap();
        SECURE_SETTINGS = new HashMap<String, Setting<SecureString>>();
        Setting.Property[] defaultProperties = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered};
        Setting.Property[] deprecatedProperties = new Setting.Property[]{Setting.Property.DeprecatedWarning, Setting.Property.NodeScope, Setting.Property.Filtered};
        for (String key : SslConfigurationKeys.getStringKeys()) {
            settingName = "reindex.ssl." + key;
            properties = SslConfigurationKeys.isDeprecated((String)key) ? deprecatedProperties : defaultProperties;
            SETTINGS.put(settingName, Setting.simpleString((String)settingName, (Setting.Property[])properties));
        }
        for (String key : SslConfigurationKeys.getListKeys()) {
            settingName = "reindex.ssl." + key;
            properties = SslConfigurationKeys.isDeprecated((String)key) ? deprecatedProperties : defaultProperties;
            SETTINGS.put(settingName, Setting.stringListSetting((String)settingName, (Setting.Property[])properties));
        }
        for (String key : SslConfigurationKeys.getSecureStringKeys()) {
            settingName = "reindex.ssl." + key;
            SECURE_SETTINGS.put(settingName, (Setting<SecureString>)SecureSetting.secureString((String)settingName, null, (Setting.Property[])new Setting.Property[0]));
        }
    }
}

