/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.xpack.core.textstructure.structurefinder.FieldStats;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureUtils;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;

public final class GrokPatternCreator {
    private static final boolean ECS_COMPATIBILITY_DISABLED = false;
    private static final boolean ECS_COMPATIBILITY_ENABLED = true;
    private static final Logger logger = LogManager.getLogger(GrokPatternCreator.class);
    private static final Map<Character, Boolean> PUNCTUATION_OR_SPACE_NEEDS_ESCAPING;
    private static final String PREFACE = "preface";
    private static final String VALUE = "value";
    private static final String EPILOGUE = "epilogue";
    private static final List<FullMatchGrokPatternCandidate> FULL_MATCH_GROK_PATTERNS_LEGACY;
    private static final List<FullMatchGrokPatternCandidate> FULL_MATCH_GROK_PATTERNS_ECS;
    private static final List<GrokPatternCandidate> ORDERED_CANDIDATE_GROK_PATTERNS_LEGACY;
    private static final List<GrokPatternCandidate> ORDERED_CANDIDATE_GROK_PATTERNS_ECS;
    private final List<String> explanation;
    private final Collection<String> sampleMessages;
    private final Map<String, Object> mappings;
    private final Map<String, FieldStats> fieldStats;
    private final PatternBank grokPatternBank;
    private final Map<String, Integer> fieldNameCountStore = new HashMap<String, Integer>();
    private final StringBuilder overallGrokPatternBuilder = new StringBuilder();
    private final TimeoutChecker timeoutChecker;
    private final boolean ecsCompatibility;

    public GrokPatternCreator(List<String> explanation, Collection<String> sampleMessages, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, Map<String, String> customGrokPatternDefinitions, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
        this.explanation = Objects.requireNonNull(explanation);
        this.sampleMessages = Collections.unmodifiableCollection(sampleMessages);
        this.mappings = mappings;
        this.fieldStats = fieldStats;
        this.grokPatternBank = GrokBuiltinPatterns.get((boolean)ecsCompatibility).extendWith(customGrokPatternDefinitions);
        this.timeoutChecker = Objects.requireNonNull(timeoutChecker);
        this.ecsCompatibility = ecsCompatibility;
    }

    public Tuple<String, String> findFullLineGrokPattern(String timestampField) {
        for (FullMatchGrokPatternCandidate candidate : this.ecsCompatibility ? FULL_MATCH_GROK_PATTERNS_ECS : FULL_MATCH_GROK_PATTERNS_LEGACY) {
            if (timestampField != null && !timestampField.equals(candidate.getTimeField()) || !candidate.matchesAll(this.sampleMessages, this.timeoutChecker)) continue;
            return candidate.processMatch(this.explanation, this.sampleMessages, this.mappings, this.fieldStats, this.timeoutChecker, this.ecsCompatibility);
        }
        return null;
    }

    public void validateFullLineGrokPattern(String grokPattern, String timestampField) {
        FullMatchGrokPatternCandidate candidate = FullMatchGrokPatternCandidate.fromGrokPattern(grokPattern, timestampField, this.grokPatternBank);
        if (!candidate.matchesAll(this.sampleMessages, this.timeoutChecker)) {
            throw new IllegalArgumentException("Supplied Grok pattern [" + grokPattern + "] does not match sample messages");
        }
        candidate.processMatch(this.explanation, this.sampleMessages, this.mappings, this.fieldStats, this.timeoutChecker, this.ecsCompatibility);
    }

    public String createGrokPatternFromExamples(String seedPatternName, Map<String, String> seedMapping, String seedFieldName) {
        this.overallGrokPatternBuilder.setLength(0);
        if (seedPatternName == null) {
            this.appendBestGrokMatchForStrings(true, this.sampleMessages, false, 0);
        } else {
            PrecalculatedMappingGrokPatternCandidate seedCandidate = new PrecalculatedMappingGrokPatternCandidate(seedPatternName, seedMapping, seedFieldName, this.grokPatternBank);
            this.processCandidateAndSplit(seedCandidate, true, this.sampleMessages, false, 0, false, 0);
        }
        return this.overallGrokPatternBuilder.toString().replace("\t", "\\t").replace("\n", "\\n");
    }

    StringBuilder getOverallGrokPatternBuilder() {
        return this.overallGrokPatternBuilder;
    }

    private void processCandidateAndSplit(GrokPatternCandidate chosenPattern, boolean isLast, Collection<String> snippets, boolean ignoreKeyValueCandidateLeft, int ignoreValueOnlyCandidatesLeft, boolean ignoreKeyValueCandidateRight, int ignoreValueOnlyCandidatesRight) {
        ArrayList<String> prefaces = new ArrayList<String>();
        ArrayList<String> epilogues = new ArrayList<String>();
        String patternBuilderContent = chosenPattern.processCaptures(this.explanation, this.fieldNameCountStore, snippets, prefaces, epilogues, this.mappings, this.fieldStats, this.timeoutChecker, this.ecsCompatibility);
        this.appendBestGrokMatchForStrings(false, prefaces, ignoreKeyValueCandidateLeft, ignoreValueOnlyCandidatesLeft);
        this.overallGrokPatternBuilder.append(patternBuilderContent);
        this.appendBestGrokMatchForStrings(isLast, epilogues, ignoreKeyValueCandidateRight, ignoreValueOnlyCandidatesRight);
    }

    void appendBestGrokMatchForStrings(boolean isLast, Collection<String> snippets, boolean ignoreKeyValueCandidate, int ignoreValueOnlyCandidates) {
        snippets = this.adjustForPunctuation(snippets);
        GrokPatternCandidate bestCandidate = null;
        if (!snippets.isEmpty()) {
            KeyValueGrokPatternCandidate kvCandidate = new KeyValueGrokPatternCandidate();
            if (!ignoreKeyValueCandidate && kvCandidate.matchesAll(snippets)) {
                bestCandidate = kvCandidate;
            } else {
                ignoreKeyValueCandidate = true;
                List<GrokPatternCandidate> orderedCandidateGrokPatterns = this.ecsCompatibility ? ORDERED_CANDIDATE_GROK_PATTERNS_ECS : ORDERED_CANDIDATE_GROK_PATTERNS_LEGACY;
                for (GrokPatternCandidate candidate : orderedCandidateGrokPatterns.subList(ignoreValueOnlyCandidates, orderedCandidateGrokPatterns.size())) {
                    if (candidate.matchesAll(snippets)) {
                        bestCandidate = candidate;
                        break;
                    }
                    ++ignoreValueOnlyCandidates;
                }
            }
        }
        if (bestCandidate == null) {
            if (isLast) {
                this.finalizeGrokPattern(snippets);
            } else {
                this.addIntermediateRegex(snippets);
            }
        } else {
            this.processCandidateAndSplit(bestCandidate, isLast, snippets, true, ignoreValueOnlyCandidates + (ignoreKeyValueCandidate ? 1 : 0), ignoreKeyValueCandidate, ignoreValueOnlyCandidates);
        }
    }

    Collection<String> adjustForPunctuation(Collection<String> snippets) {
        assert (!snippets.isEmpty());
        StringBuilder commonInitialPunctuation = new StringBuilder();
        for (String snippet2 : snippets) {
            if (commonInitialPunctuation.length() == 0) {
                for (index = 0; index < snippet2.length() && PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.get(Character.valueOf(ch = snippet2.charAt(index))) != null; ++index) {
                    commonInitialPunctuation.append(ch);
                }
            } else {
                if (commonInitialPunctuation.length() > snippet2.length()) {
                    commonInitialPunctuation.delete(snippet2.length(), commonInitialPunctuation.length());
                }
                for (index = 0; index < commonInitialPunctuation.length(); ++index) {
                    ch = snippet2.charAt(index);
                    if (ch == commonInitialPunctuation.charAt(index)) continue;
                    commonInitialPunctuation.delete(index, commonInitialPunctuation.length());
                    break;
                }
            }
            if (commonInitialPunctuation.length() > 1) continue;
            return snippets;
        }
        int numLiteralCharacters = commonInitialPunctuation.length() - 1;
        for (int index = 0; index < numLiteralCharacters; ++index) {
            char ch = commonInitialPunctuation.charAt(index);
            if (PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.getOrDefault(Character.valueOf(ch), false).booleanValue()) {
                this.overallGrokPatternBuilder.append('\\');
            }
            this.overallGrokPatternBuilder.append(ch);
        }
        return snippets.stream().map(snippet -> snippet.substring(numLiteralCharacters)).collect(Collectors.toList());
    }

    static String buildFieldName(Map<String, Integer> fieldNameCountStore, String fieldName) {
        Integer numberSeen = fieldNameCountStore.compute(fieldName, (k, v) -> 1 + (v == null ? 0 : v));
        return numberSeen > 1 ? fieldName + numberSeen : fieldName;
    }

    private void addIntermediateRegex(Collection<String> snippets) {
        GrokPatternCreator.addIntermediateRegex(this.overallGrokPatternBuilder, snippets);
    }

    public static int addIntermediateRegex(StringBuilder patternBuilder, Collection<String> snippets) {
        if (snippets.isEmpty()) {
            return 0;
        }
        List<String> others = new ArrayList<String>(snippets);
        String driver = (String)others.remove(others.size() - 1);
        char lastPunctOrSpace = '\u0000';
        ArrayList<Character> charsPrecedingWildcard = new ArrayList<Character>();
        boolean wildcardRequiredIfNonMatchFound = true;
        for (int i = 0; i < driver.length(); ++i) {
            char ch = driver.charAt(i);
            Boolean punctuationOrSpaceNeedsEscaping = PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.get(Character.valueOf(ch));
            if (punctuationOrSpaceNeedsEscaping != null && others.stream().allMatch(other -> other.indexOf(ch) >= 0)) {
                if (wildcardRequiredIfNonMatchFound && others.stream().anyMatch(other -> other.indexOf(ch) > 0)) {
                    patternBuilder.append(".*?");
                    charsPrecedingWildcard.add(Character.valueOf(lastPunctOrSpace));
                }
                if (punctuationOrSpaceNeedsEscaping.booleanValue()) {
                    patternBuilder.append('\\');
                }
                patternBuilder.append(ch);
                wildcardRequiredIfNonMatchFound = true;
                others = others.stream().map(other -> other.substring(other.indexOf(ch) + 1)).collect(Collectors.toList());
                lastPunctOrSpace = ch;
                continue;
            }
            if (!wildcardRequiredIfNonMatchFound) continue;
            patternBuilder.append(".*?");
            charsPrecedingWildcard.add(Character.valueOf(lastPunctOrSpace));
            wildcardRequiredIfNonMatchFound = false;
        }
        if (wildcardRequiredIfNonMatchFound && others.stream().anyMatch(s -> !s.isEmpty())) {
            patternBuilder.append(".*?");
        }
        return GrokPatternCreator.longestRun(charsPrecedingWildcard);
    }

    static int longestRun(List<?> sequence) {
        if (sequence.size() <= 1) {
            return sequence.size();
        }
        int maxSoFar = 0;
        int thisCount = 1;
        for (int index = 1; index < sequence.size(); ++index) {
            if (sequence.get(index).equals(sequence.get(index - 1))) {
                ++thisCount;
                continue;
            }
            if ((maxSoFar = Math.max(maxSoFar, thisCount)) >= sequence.size() - index) {
                return maxSoFar;
            }
            thisCount = 1;
        }
        maxSoFar = Math.max(maxSoFar, thisCount);
        return maxSoFar;
    }

    private void finalizeGrokPattern(Collection<String> snippets) {
        if (snippets.stream().allMatch(String::isEmpty)) {
            return;
        }
        ArrayList<String> others = new ArrayList<String>(snippets);
        String driver = (String)others.remove(others.size() - 1);
        for (int i = 0; i < driver.length(); ++i) {
            char ch = driver.charAt(i);
            int driverIndex = i;
            Boolean punctuationOrSpaceNeedsEscaping = PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.get(Character.valueOf(ch));
            if (punctuationOrSpaceNeedsEscaping == null || !others.stream().allMatch(other -> other.length() > driverIndex && other.charAt(driverIndex) == ch)) break;
            if (punctuationOrSpaceNeedsEscaping.booleanValue()) {
                this.overallGrokPatternBuilder.append('\\');
            }
            this.overallGrokPatternBuilder.append(ch);
            if (i != driver.length() - 1) continue;
            if (!others.stream().allMatch(driver::equals)) continue;
            return;
        }
        this.overallGrokPatternBuilder.append(".*");
    }

    static {
        HashMap punctuationOrSpaceNeedsEscaping = new HashMap();
        String punctuationAndSpaceCharacters = "\"'`\u2018\u2019\u201c\u201d#@%=\\/|~:;,<>()[]{}\u00ab\u00bb^$*\u00bf?\u00a1!\u00a7\u00b6 \t\n";
        String punctuationThatNeedsEscaping = "\\|()[]{}^$*?";
        punctuationAndSpaceCharacters.chars().forEach(c -> punctuationOrSpaceNeedsEscaping.put(Character.valueOf((char)c), punctuationThatNeedsEscaping.indexOf(c) >= 0));
        PUNCTUATION_OR_SPACE_NEEDS_ESCAPING = Collections.unmodifiableMap(punctuationOrSpaceNeedsEscaping);
        FULL_MATCH_GROK_PATTERNS_LEGACY = Arrays.asList(FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("BACULA_LOGLINE", "bts"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("CATALINALOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("COMBINEDAPACHELOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("COMMONAPACHELOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("ELB_ACCESS_LOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("HAPROXYHTTP", "syslog_timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("HAPROXYTCP", "syslog_timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("HTTPD20_ERRORLOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("HTTPD24_ERRORLOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("NAGIOSLOGLINE", "nagios_epoch"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("NETSCREENSESSIONLOG", "date"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("RAILS3", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("RUBY_LOGGER", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("SHOREWALL", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameLegacy("TOMCATLOG", "timestamp"));
        FULL_MATCH_GROK_PATTERNS_ECS = Arrays.asList(FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("BACULA_LOGLINE", "bts"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("CATALINALOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("COMBINEDAPACHELOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("COMMONAPACHELOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("ELB_ACCESS_LOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("HAPROXYHTTP", "syslog_timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("HAPROXYTCP", "syslog_timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("HTTPD20_ERRORLOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("HTTPD24_ERRORLOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("NAGIOSLOGLINE", "nagios_epoch"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("NETSCREENSESSIONLOG", "date"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("RAILS3", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("RUBY_LOGGER", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("SHOREWALL", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternNameEcs("TOMCATLOG", "timestamp"));
        ORDERED_CANDIDATE_GROK_PATTERNS_LEGACY = Arrays.asList(new ValueOnlyGrokPatternCandidate("TOMCAT_DATESTAMP", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("TIMESTAMP_ISO8601", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("DATESTAMP_RFC822", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("DATESTAMP_RFC2822", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("DATESTAMP_OTHER", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("DATESTAMP_EVENTLOG", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("HTTPDERROR_DATE", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("SYSLOGTIMESTAMP", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("HTTPDATE", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("CATALINA_DATESTAMP", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("CISCOTIMESTAMP", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("DATESTAMP", "date", "extra_timestamp", false), new ValueOnlyGrokPatternCandidate("LOGLEVEL", "keyword", "loglevel", false), new ValueOnlyGrokPatternCandidate("URI", "keyword", "uri", false), new ValueOnlyGrokPatternCandidate("UUID", "keyword", "uuid", false), new ValueOnlyGrokPatternCandidate("MAC", "keyword", "macaddress", false), new ValueOnlyGrokPatternCandidate("PATH", "keyword", "path", "(?<!\\w)", "(?!\\w)", false), new ValueOnlyGrokPatternCandidate("EMAILADDRESS", "keyword", "email", false), new ValueOnlyGrokPatternCandidate("IP", "ip", "ipaddress", false), new ValueOnlyGrokPatternCandidate("DATE", "date", "date", false), new ValueOnlyGrokPatternCandidate("TIME", "keyword", "time", false), new ValueOnlyGrokPatternCandidate("QUOTEDSTRING", "keyword", "field", "", "", false), new ValueOnlyGrokPatternCandidate("INT", "long", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)", false), new ValueOnlyGrokPatternCandidate("NUMBER", "double", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)", false), new ValueOnlyGrokPatternCandidate("BASE16NUM", "keyword", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\w)", false));
        ORDERED_CANDIDATE_GROK_PATTERNS_ECS = Arrays.asList(new ValueOnlyGrokPatternCandidate("TOMCAT_DATESTAMP", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("TIMESTAMP_ISO8601", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("DATESTAMP_RFC822", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("DATESTAMP_RFC2822", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("DATESTAMP_OTHER", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("DATESTAMP_EVENTLOG", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("HTTPDERROR_DATE", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("SYSLOGTIMESTAMP", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("HTTPDATE", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("CATALINA_DATESTAMP", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("CISCOTIMESTAMP", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("DATESTAMP", "date", "extra_timestamp", true), new ValueOnlyGrokPatternCandidate("LOGLEVEL", "keyword", "log.level", true), new ValueOnlyGrokPatternCandidate("URI", "keyword", "url.original", true), new ValueOnlyGrokPatternCandidate("UUID", "keyword", "uuid", true), new ValueOnlyGrokPatternCandidate("MAC", "keyword", "macaddress", true), new ValueOnlyGrokPatternCandidate("PATH", "keyword", "path", "(?<!\\w)", "(?!\\w)", true), new ValueOnlyGrokPatternCandidate("EMAILADDRESS", "keyword", "email", true), new ValueOnlyGrokPatternCandidate("IP", "ip", "ipaddress", true), new ValueOnlyGrokPatternCandidate("DATE", "date", "date", true), new ValueOnlyGrokPatternCandidate("TIME", "keyword", "time", true), new ValueOnlyGrokPatternCandidate("QUOTEDSTRING", "keyword", "field", "", "", true), new ValueOnlyGrokPatternCandidate("INT", "long", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)", true), new ValueOnlyGrokPatternCandidate("NUMBER", "double", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)", true), new ValueOnlyGrokPatternCandidate("BASE16NUM", "keyword", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\w)", true));
    }

    static class FullMatchGrokPatternCandidate {
        private final String grokPattern;
        private final String timeField;
        private final Grok grok;

        static FullMatchGrokPatternCandidate fromGrokPatternNameLegacy(String grokPatternName, String timeField) {
            return new FullMatchGrokPatternCandidate("%{" + grokPatternName + "}", timeField, GrokBuiltinPatterns.legacyPatterns());
        }

        static FullMatchGrokPatternCandidate fromGrokPatternNameEcs(String grokPatternName, String timeField) {
            return new FullMatchGrokPatternCandidate("%{" + grokPatternName + "}", timeField, GrokBuiltinPatterns.ecsV1Patterns());
        }

        static FullMatchGrokPatternCandidate fromGrokPatternName(String grokPatternName, String timeField, PatternBank grokPatternDefinitions) {
            return new FullMatchGrokPatternCandidate("%{" + grokPatternName + "}", timeField, grokPatternDefinitions);
        }

        static FullMatchGrokPatternCandidate fromGrokPatternLegacy(String grokPattern, String timeField) {
            return new FullMatchGrokPatternCandidate(grokPattern, timeField, GrokBuiltinPatterns.get((boolean)false));
        }

        static FullMatchGrokPatternCandidate fromGrokPatternEcs(String grokPattern, String timeField) {
            return new FullMatchGrokPatternCandidate(grokPattern, timeField, GrokBuiltinPatterns.get((boolean)true));
        }

        static FullMatchGrokPatternCandidate fromGrokPattern(String grokPattern, String timeField, PatternBank grokPatternBank) {
            return new FullMatchGrokPatternCandidate(grokPattern, timeField, grokPatternBank);
        }

        private FullMatchGrokPatternCandidate(String grokPattern, String timeField, PatternBank grokPatternDefinitions) {
            this.grokPattern = grokPattern;
            this.timeField = timeField;
            this.grok = new Grok(grokPatternDefinitions, grokPattern, TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
        }

        public String getTimeField() {
            return this.timeField;
        }

        public boolean matchesAll(Collection<String> sampleMessages, TimeoutChecker timeoutChecker) {
            for (String sampleMessage : sampleMessages) {
                if (!this.grok.match(sampleMessage)) {
                    return false;
                }
                timeoutChecker.check("full message Grok pattern matching");
            }
            return true;
        }

        public Tuple<String, String> processMatch(List<String> explanation, Collection<String> sampleMessages, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
            if (this.grokPattern.startsWith("%{") && this.grokPattern.endsWith("}")) {
                explanation.add("A full message Grok pattern [" + this.grokPattern.substring(2, this.grokPattern.length() - 1) + "] looks appropriate");
            }
            if (mappings != null || fieldStats != null) {
                HashMap<String, Collection> valuesPerField = new HashMap<String, Collection>();
                for (String string : sampleMessages) {
                    Map<String, Object> captures = timeoutChecker.grokCaptures(this.grok, string, "full message Grok pattern field extraction");
                    if (captures == null) {
                        throw new IllegalStateException("[" + this.grokPattern + "] does not match snippet [" + string + "]");
                    }
                    for (Map.Entry<String, Object> capture : captures.entrySet()) {
                        String fieldName = capture.getKey();
                        String fieldValue = capture.getValue().toString();
                        valuesPerField.compute(fieldName, (k, v) -> {
                            if (v == null) {
                                return new ArrayList<String>(Collections.singletonList(fieldValue));
                            }
                            v.add(fieldValue);
                            return v;
                        });
                    }
                }
                for (Map.Entry entry : valuesPerField.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    Map<String, String> mapping = TextStructureUtils.guessScalarMapping(explanation, fieldName, (Collection)entry.getValue(), timeoutChecker, ecsCompatibility);
                    timeoutChecker.check("mapping determination");
                    if (mappings != null && !fieldName.equals(this.timeField)) {
                        mappings.put(fieldName, mapping);
                    }
                    if (fieldStats == null) continue;
                    fieldStats.put(fieldName, TextStructureUtils.calculateFieldStats(mapping, (Collection)entry.getValue(), timeoutChecker));
                }
            }
            return new Tuple((Object)this.timeField, (Object)this.grokPattern);
        }
    }

    static class PrecalculatedMappingGrokPatternCandidate
    extends ValueOnlyGrokPatternCandidate {
        PrecalculatedMappingGrokPatternCandidate(String grokPatternName, Map<String, String> mapping, String fieldName, PatternBank grokPatternDefinitions) {
            super(grokPatternName, mapping, fieldName, "\\b", "\\b", grokPatternDefinitions);
        }

        @Override
        public String processCaptures(List<String> explanation, Map<String, Integer> fieldNameCountStore, Collection<String> snippets, Collection<String> prefaces, Collection<String> epilogues, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
            return super.processCaptures(explanation, fieldNameCountStore, snippets, prefaces, epilogues, null, fieldStats, timeoutChecker, ecsCompatibility);
        }
    }

    static interface GrokPatternCandidate {
        public boolean matchesAll(Collection<String> var1);

        public String processCaptures(List<String> var1, Map<String, Integer> var2, Collection<String> var3, Collection<String> var4, Collection<String> var5, Map<String, Object> var6, Map<String, FieldStats> var7, TimeoutChecker var8, boolean var9);
    }

    static class KeyValueGrokPatternCandidate
    implements GrokPatternCandidate {
        private static final Pattern KV_FINDER = Pattern.compile("\\b(\\w+)=[\\w.-]+");
        private String fieldName;

        KeyValueGrokPatternCandidate() {
        }

        @Override
        public boolean matchesAll(Collection<String> snippets) {
            LinkedHashSet<String> candidateNames = new LinkedHashSet<String>();
            boolean isFirst = true;
            for (String snippet : snippets) {
                if (isFirst) {
                    Matcher matcher = KV_FINDER.matcher(snippet);
                    while (matcher.find()) {
                        candidateNames.add(matcher.group(1));
                    }
                    isFirst = false;
                } else {
                    candidateNames.removeIf(candidateName -> !Pattern.compile("\\b" + candidateName + "=[\\w.-]+").matcher(snippet).find());
                }
                if (!candidateNames.isEmpty()) continue;
                break;
            }
            return (this.fieldName = (String)candidateNames.stream().findFirst().orElse(null)) != null;
        }

        @Override
        public String processCaptures(List<String> explanation, Map<String, Integer> fieldNameCountStore, Collection<String> snippets, Collection<String> prefaces, Collection<String> epilogues, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
            if (this.fieldName == null) {
                throw new IllegalStateException("Cannot process KV matches until a field name has been determined");
            }
            Grok grok = new Grok(GrokBuiltinPatterns.get((boolean)ecsCompatibility), "(?m)%{DATA:preface}\\b" + this.fieldName + "=%{USER:value}%{GREEDYDATA:epilogue}", TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
            ArrayList<String> values = new ArrayList<String>();
            for (String snippet : snippets) {
                Map captures = grok.captures(snippet);
                if (captures == null) {
                    throw new IllegalStateException("[\\b" + this.fieldName + "=%{USER}] does not match snippet [" + snippet + "]");
                }
                prefaces.add(captures.getOrDefault(GrokPatternCreator.PREFACE, "").toString());
                values.add(captures.getOrDefault(GrokPatternCreator.VALUE, "").toString());
                epilogues.add(captures.getOrDefault(GrokPatternCreator.EPILOGUE, "").toString());
                timeoutChecker.check("full message Grok pattern field extraction");
            }
            String adjustedFieldName = GrokPatternCreator.buildFieldName(fieldNameCountStore, this.fieldName);
            Map<String, String> mapping = TextStructureUtils.guessScalarMapping(explanation, adjustedFieldName, values, timeoutChecker, ecsCompatibility);
            timeoutChecker.check("mapping determination");
            if (mappings != null) {
                mappings.put(adjustedFieldName, mapping);
            }
            if (fieldStats != null) {
                fieldStats.put(adjustedFieldName, TextStructureUtils.calculateFieldStats(mapping, values, timeoutChecker));
            }
            return "\\b" + this.fieldName + "=%{USER:" + adjustedFieldName + "}";
        }
    }

    static class ValueOnlyGrokPatternCandidate
    implements GrokPatternCandidate {
        private final String grokPatternName;
        private final Map<String, String> mapping;
        private final String fieldName;
        private final Grok grok;

        ValueOnlyGrokPatternCandidate(String grokPatternName, String mappingType, String fieldName, boolean ecsCompatibility) {
            this(grokPatternName, Collections.singletonMap("type", mappingType), fieldName, "\\b", "\\b", GrokBuiltinPatterns.get((boolean)ecsCompatibility));
        }

        ValueOnlyGrokPatternCandidate(String grokPatternName, String mappingType, String fieldName, PatternBank grokPatternDefinitions) {
            this(grokPatternName, Collections.singletonMap("type", mappingType), fieldName, "\\b", "\\b", grokPatternDefinitions);
        }

        ValueOnlyGrokPatternCandidate(String grokPatternName, String mappingType, String fieldName, String preBreak, String postBreak, boolean ecsCompatibility) {
            this(grokPatternName, Collections.singletonMap("type", mappingType), fieldName, preBreak, postBreak, GrokBuiltinPatterns.get((boolean)ecsCompatibility));
        }

        ValueOnlyGrokPatternCandidate(String grokPatternName, Map<String, String> mapping, String fieldName, String preBreak, String postBreak, PatternBank grokPatternDefinitions) {
            this.grokPatternName = Objects.requireNonNull(grokPatternName);
            this.mapping = Collections.unmodifiableMap(mapping);
            this.fieldName = Objects.requireNonNull(fieldName);
            this.grok = new Grok(grokPatternDefinitions, "(?m)%{DATA:preface}" + Objects.requireNonNull(preBreak) + "%{" + grokPatternName + ":value}" + Objects.requireNonNull(postBreak) + "%{GREEDYDATA:epilogue}", TimeoutChecker.watchdog, arg_0 -> ((Logger)logger).warn(arg_0));
        }

        @Override
        public boolean matchesAll(Collection<String> snippets) {
            return snippets.stream().allMatch(arg_0 -> ((Grok)this.grok).match(arg_0));
        }

        @Override
        public String processCaptures(List<String> explanation, Map<String, Integer> fieldNameCountStore, Collection<String> snippets, Collection<String> prefaces, Collection<String> epilogues, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker, boolean ecsCompatibility) {
            ArrayList<String> values = new ArrayList<String>();
            for (String snippet : snippets) {
                Map<String, Object> captures = timeoutChecker.grokCaptures(this.grok, snippet, "full message Grok pattern field extraction");
                if (captures == null) {
                    throw new IllegalStateException("[%{" + this.grokPatternName + "}] does not match snippet [" + snippet + "]");
                }
                prefaces.add(captures.getOrDefault(GrokPatternCreator.PREFACE, "").toString());
                values.add(captures.getOrDefault(GrokPatternCreator.VALUE, "").toString());
                epilogues.add(captures.getOrDefault(GrokPatternCreator.EPILOGUE, "").toString());
            }
            String adjustedFieldName = GrokPatternCreator.buildFieldName(fieldNameCountStore, this.fieldName);
            Map<String, String> adjustedMapping = this.mapping;
            if (TextStructureUtils.DATE_MAPPING_WITHOUT_FORMAT.equals(adjustedMapping)) {
                block7: {
                    try {
                        adjustedMapping = TextStructureUtils.findTimestampMapping(explanation, values, timeoutChecker, ecsCompatibility);
                    }
                    catch (IllegalArgumentException e) {
                        if ($assertionsDisabled || e == null) break block7;
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
                timeoutChecker.check("mapping determination");
            }
            if (mappings != null) {
                mappings.put(adjustedFieldName, adjustedMapping);
            }
            if (fieldStats != null) {
                fieldStats.put(adjustedFieldName, TextStructureUtils.calculateFieldStats(adjustedMapping, values, timeoutChecker));
            }
            return "%{" + this.grokPatternName + ":" + adjustedFieldName + "}";
        }
    }
}

