/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToLongFunction;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.join.aggregations.ChildrenToParentAggregator;
import org.elasticsearch.join.aggregations.ParentAggregatorFactory;
import org.elasticsearch.join.mapper.Joiner;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ParentAggregationBuilder
extends ValuesSourceAggregationBuilder<ParentAggregationBuilder> {
    public static final String NAME = "parent";
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ParentAggregationBuilder(String name, String childType) {
        super(name);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    protected ParentAggregationBuilder(ParentAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metadata);
        this.childType = clone.childType;
        this.childFilter = clone.childFilter;
        this.parentFilter = clone.parentFilter;
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.KEYWORD;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ParentAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ParentAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.childType = in.readString();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    public boolean supportsParallelCollection(ToLongFunction<String> fieldCardinalityResolver) {
        return false;
    }

    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ParentAggregatorFactory(this.name, config, this.childFilter, this.parentFilter, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected ValuesSourceConfig resolveConfig(AggregationContext context) {
        ValuesSourceConfig config;
        Joiner joiner = Joiner.getJoiner(context);
        if (joiner != null && joiner.childTypeExists(this.childType)) {
            this.parentFilter = joiner.parentFilter(this.childType);
            this.childFilter = joiner.filter(this.childType);
            MappedFieldType fieldType = context.getFieldType(joiner.parentJoinField(this.childType));
            config = ValuesSourceConfig.resolveFieldOnly((MappedFieldType)fieldType, (AggregationContext)context);
        } else {
            config = ValuesSourceConfig.resolveUnmapped((ValuesSourceType)this.defaultValueSourceType(), (AggregationContext)context);
        }
        return config;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ChildrenToParentAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ParentAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for parent aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ParentAggregationBuilder(aggregationName, childType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.childType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ParentAggregationBuilder other = (ParentAggregationBuilder)((Object)obj);
        return Objects.equals(this.childType, other.childType);
    }

    public String getType() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }
}

