/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.migrate.action.CreateIndexFromSourceAction;

public class CreateIndexFromSourceTransportAction
extends HandledTransportAction<CreateIndexFromSourceAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(CreateIndexFromSourceTransportAction.class);
    private final ClusterService clusterService;
    private final Client client;
    private final IndexScopedSettings indexScopedSettings;
    private static final Set<String> INDEX_BLOCK_SETTINGS = Set.of(IndexMetadata.SETTING_READ_ONLY, IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE, IndexMetadata.SETTING_BLOCKS_WRITE, IndexMetadata.SETTING_BLOCKS_METADATA, IndexMetadata.SETTING_BLOCKS_READ);
    private static final Set<String> SPECIFIC_SETTINGS_TO_REMOVE = Set.of(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.getKey(), IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.getKey());

    @Inject
    public CreateIndexFromSourceTransportAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/index/create_from_source", false, transportService, actionFilters, CreateIndexFromSourceAction.Request::new, (Executor)transportService.getThreadPool().executor("generic"));
        this.clusterService = clusterService;
        this.client = client;
        this.indexScopedSettings = indexScopedSettings;
    }

    protected void doExecute(Task task, CreateIndexFromSourceAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        Map<String, Object> mergeMappings;
        IndexMetadata sourceIndex = this.clusterService.state().getMetadata().index(request.sourceIndex());
        if (sourceIndex == null) {
            listener.onFailure((Exception)new IndexNotFoundException(request.sourceIndex()));
            return;
        }
        logger.debug("Creating destination index [{}] for source index [{}]", (Object)request.destIndex(), (Object)request.sourceIndex());
        Settings.Builder settings = Settings.builder().put(this.filterSettings(sourceIndex));
        if (!request.settingsOverride().isEmpty()) {
            this.applyOverrides(settings, request.settingsOverride());
        }
        if (request.removeIndexBlocks()) {
            INDEX_BLOCK_SETTINGS.forEach(arg_0 -> ((Settings.Builder)settings).remove(arg_0));
        }
        try {
            mergeMappings = CreateIndexFromSourceTransportAction.mergeMappings(sourceIndex.mapping(), request.mappingsOverride());
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(request.destIndex()).settings(settings);
        createIndexRequest.cause("create-index-from-source");
        if (!mergeMappings.isEmpty()) {
            createIndexRequest.mapping(mergeMappings);
        }
        createIndexRequest.setParentTask(new TaskId(this.clusterService.localNode().getId(), task.getId()));
        this.client.admin().indices().create(createIndexRequest, listener.map(response -> response));
    }

    private void applyOverrides(Settings.Builder settings, Settings overrides) {
        overrides.keySet().forEach(key -> {
            if (overrides.get(key) != null) {
                settings.put(key, overrides.get(key));
            } else {
                settings.remove(key);
            }
        });
    }

    private static Map<String, Object> toMap(@Nullable MappingMetadata sourceMapping) {
        return Optional.ofNullable(sourceMapping).map(MappingMetadata::source).map(CompressedXContent::uncompressed).map(s -> (Map)XContentHelper.convertToMap((BytesReference)s, (boolean)true, (XContentType)XContentType.JSON).v2()).orElse(Map.of());
    }

    private static Map<String, Object> mergeMappings(@Nullable MappingMetadata sourceMapping, Map<String, Object> mappingAddition) throws IOException {
        Map<String, Object> combinedMappingMap = new HashMap<String, Object>(CreateIndexFromSourceTransportAction.toMap(sourceMapping));
        XContentHelper.update(combinedMappingMap, mappingAddition, (boolean)true);
        if (sourceMapping != null && combinedMappingMap.size() == 1 && combinedMappingMap.containsKey(sourceMapping.type())) {
            combinedMappingMap = (Map)combinedMappingMap.get(sourceMapping.type());
        }
        return combinedMappingMap;
    }

    private Settings filterSettings(IndexMetadata sourceIndex) {
        Settings sourceSettings = sourceIndex.getSettings();
        Settings.Builder builder = Settings.builder();
        boolean isServerless = DiscoveryNode.isStateless((Settings)this.clusterService.getSettings());
        for (String key : sourceSettings.keySet()) {
            Setting setting = this.indexScopedSettings.get(key);
            if (setting == null) {
                assert (this.indexScopedSettings.isPrivateSetting(key)) : key;
                continue;
            }
            if (setting.isPrivateIndex() || setting.getProperties().contains(Setting.Property.NotCopyableOnResize) || setting.getProperties().contains(Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8) || isServerless && !setting.isServerlessPublic() || SPECIFIC_SETTINGS_TO_REMOVE.contains(key)) continue;
            builder.copy(key, sourceSettings);
        }
        return builder.build();
    }
}

