/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.system_indices.task.SystemResourceMigrationInfo;

final class SystemIndexMigrationInfo
extends SystemResourceMigrationInfo {
    private final IndexMetadata currentIndex;
    private final Settings settings;
    private final String mapping;
    private final String migrationScript;
    private final boolean allowsTemplates;

    private SystemIndexMigrationInfo(IndexMetadata currentIndex, String featureName, Settings settings, String mapping, String origin, String migrationScript, SystemIndices.Feature owningFeature, boolean allowsTemplates) {
        super(featureName, origin, owningFeature);
        this.currentIndex = currentIndex;
        this.settings = settings;
        this.mapping = mapping;
        this.migrationScript = migrationScript;
        this.allowsTemplates = allowsTemplates;
    }

    String getCurrentIndexName() {
        return this.currentIndex.getIndex().getName();
    }

    @Override
    protected String getCurrentResourceName() {
        return this.getCurrentIndexName();
    }

    @Override
    Stream<IndexMetadata> getIndices(Metadata metadata) {
        return Stream.of(this.currentIndex);
    }

    @Override
    boolean isCurrentIndexClosed() {
        return IndexMetadata.State.CLOSE.equals((Object)this.currentIndex.getState());
    }

    String getNextIndexName() {
        return this.currentIndex.getIndex().getName() + SystemIndices.UPGRADED_INDEX_SUFFIX;
    }

    String getMappings() {
        return this.mapping;
    }

    Settings getSettings() {
        return this.settings;
    }

    String getMigrationScript() {
        return this.migrationScript;
    }

    boolean allowsTemplates() {
        return this.allowsTemplates;
    }

    public String toString() {
        return "IndexUpgradeInfo[currentIndex='" + this.currentIndex.getIndex().getName() + "', featureName='" + this.featureName + "', settings=" + this.settings + ", mapping='" + this.mapping + "', origin='" + this.origin + "'";
    }

    static SystemIndexMigrationInfo build(IndexMetadata currentIndex, SystemIndexDescriptor descriptor, SystemIndices.Feature feature, IndexScopedSettings indexScopedSettings) {
        String mapping;
        Settings settings;
        if (descriptor.isAutomaticallyManaged()) {
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(descriptor.getSettings());
            settingsBuilder.remove("index.version.created");
            settings = settingsBuilder.build();
            mapping = descriptor.getMappings();
        } else {
            settings = SystemIndexMigrationInfo.copySettingsForNewIndex(currentIndex.getSettings(), indexScopedSettings);
            mapping = currentIndex.mapping().source().string();
        }
        return new SystemIndexMigrationInfo(currentIndex, feature.getName(), settings, mapping, descriptor.getOrigin(), descriptor.getMigrationScript(), feature, descriptor.allowsTemplates());
    }

    private static Settings copySettingsForNewIndex(Settings currentIndexSettings, IndexScopedSettings indexScopedSettings) {
        Settings.Builder newIndexSettings = Settings.builder();
        currentIndexSettings.keySet().stream().filter(settingKey -> !indexScopedSettings.isPrivateSetting(settingKey)).map(arg_0 -> ((IndexScopedSettings)indexScopedSettings).get(arg_0)).filter(Objects::nonNull).filter(setting -> !setting.getProperties().contains(Setting.Property.NotCopyableOnResize)).filter(setting -> !setting.getProperties().contains(Setting.Property.PrivateIndex)).forEach(setting -> newIndexSettings.put(setting.getKey(), currentIndexSettings.get(setting.getKey())));
        return newIndexSettings.build();
    }
}

