/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;

public class DimensionFieldProducer
extends AbstractDownsampleFieldProducer {
    private final Dimension dimension;

    DimensionFieldProducer(String name, Dimension dimension) {
        super(name);
        this.dimension = dimension;
    }

    @Override
    public void reset() {
        this.dimension.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.dimension.isEmpty;
    }

    @Override
    public void collect(FormattedDocValues docValues, IntArrayList docIdBuffer) throws IOException {
        if (!this.dimension.isEmpty) {
            assert (this.dimension.validate(docValues, docIdBuffer));
            return;
        }
        for (int i = 0; i < docIdBuffer.size(); ++i) {
            int docId = docIdBuffer.get(i);
            if (!docValues.advanceExact(docId)) continue;
            int docValueCount = docValues.docValueCount();
            for (int j = 0; j < docValueCount; ++j) {
                this.dimension.collectOnce(docValues.nextValue());
            }
            return;
        }
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (!this.isEmpty()) {
            builder.field(this.dimension.name, this.dimension.value());
        }
    }

    static class Dimension {
        private final String name;
        private Object value;
        private boolean isEmpty;

        Dimension(String name) {
            this.name = name;
            this.isEmpty = true;
        }

        public Object value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        void reset() {
            this.value = null;
            this.isEmpty = true;
        }

        void collectOnce(Object value) {
            assert (this.isEmpty);
            Objects.requireNonNull(value);
            this.value = value;
            this.isEmpty = false;
        }

        boolean validate(FormattedDocValues docValues, IntArrayList buffer) throws IOException {
            for (int i = 0; i < buffer.size(); ++i) {
                int docId = buffer.get(i);
                if (!docValues.advanceExact(docId)) continue;
                int docValueCount = docValues.docValueCount();
                for (int j = 0; j < docValueCount; ++j) {
                    Object value = docValues.nextValue();
                    if (!value.equals(this.value)) assert (false) : "Dimension value changed without tsid change [" + value + "] != [" + this.value + "]";
                }
            }
            return true;
        }
    }
}

