/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.crypto.ntru;

import java.security.SecureRandom;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shadow.org.bouncycastle.crypto.KeyGenerationParameters;
import shadow.org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import shadow.org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import shadow.org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import shadow.org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.ntru.OWCPAKeyPair;
import shadow.org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import shadow.org.bouncycastle.util.Arrays;

public class NTRUKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUKeyGenerationParameters params;
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.params = (NTRUKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUParameters nTRUParameters = this.params.getParameters();
        NTRUParameterSet nTRUParameterSet = nTRUParameters.getParameterSet();
        byte[] byArray = new byte[nTRUParameterSet.sampleFgBytes()];
        this.random.nextBytes(byArray);
        NTRUOWCPA nTRUOWCPA = new NTRUOWCPA(nTRUParameterSet);
        OWCPAKeyPair oWCPAKeyPair = nTRUOWCPA.keypair(byArray);
        byte[] byArray2 = oWCPAKeyPair.publicKey;
        byte[] byArray3 = new byte[nTRUParameterSet.prfKeyBytes()];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = Arrays.concatenate(oWCPAKeyPair.privateKey, byArray3);
        return new AsymmetricCipherKeyPair(new NTRUPublicKeyParameters(nTRUParameters, byArray2), new NTRUPrivateKeyParameters(nTRUParameters, byArray4));
    }
}

