/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.crypto.mlkem;

import java.security.SecureRandom;
import shadow.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import shadow.org.bouncycastle.crypto.SecretWithEncapsulation;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import shadow.org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class MLKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public MLKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        byte[] byArray = new byte[32];
        this.sr.nextBytes(byArray);
        return this.internalGenerateEncapsulated(asymmetricKeyParameter, byArray);
    }

    public SecretWithEncapsulation internalGenerateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
        MLKEMPublicKeyParameters mLKEMPublicKeyParameters = (MLKEMPublicKeyParameters)asymmetricKeyParameter;
        MLKEMEngine mLKEMEngine = mLKEMPublicKeyParameters.getParameters().getEngine();
        mLKEMEngine.init(this.sr);
        byte[][] byArray2 = mLKEMEngine.kemEncrypt(mLKEMPublicKeyParameters, byArray);
        return new SecretWithEncapsulationImpl(byArray2[0], byArray2[1]);
    }
}

