/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.crypto.lms;

import shadow.org.bouncycastle.crypto.Digest;
import shadow.org.bouncycastle.pqc.crypto.lms.DigestUtil;
import shadow.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSContext;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import shadow.org.bouncycastle.pqc.crypto.lms.LmsUtils;
import shadow.org.bouncycastle.pqc.crypto.lms.SeedDerive;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class LMOtsPrivateKey {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] masterSecret;

    LMOtsPrivateKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n, byte[] byArray2) {
        this.parameter = lMOtsParameters;
        this.I = byArray;
        this.q = n;
        this.masterSecret = byArray2;
    }

    LMSContext getSignatureContext(LMSigParameters lMSigParameters, byte[][] byArray) {
        byte[] byArray2 = new byte[this.parameter.getN()];
        SeedDerive seedDerive = this.getDerivationFunction();
        seedDerive.setJ(-3);
        seedDerive.deriveSeed(byArray2, false);
        Digest digest = DigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.getI(), digest);
        LmsUtils.u32str(this.getQ(), digest);
        LmsUtils.u16str((short)-32383, digest);
        LmsUtils.byteArray(byArray2, digest);
        return new LMSContext(this, lMSigParameters, digest, byArray2, byArray);
    }

    SeedDerive getDerivationFunction() {
        SeedDerive seedDerive = new SeedDerive(this.I, this.masterSecret, DigestUtil.getDigest(this.parameter));
        seedDerive.setQ(this.q);
        return seedDerive;
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }
}

