/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHKey;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shadow.org.bouncycastle.asn1.x9.X9ECParametersHolder;
import shadow.org.bouncycastle.bcpg.AEADEncDataPacket;
import shadow.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import shadow.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import shadow.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSessionKey;
import shadow.org.bouncycastle.openpgp.operator.AbstractPublicKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PGPPad;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.RFC6637Utils;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import shadow.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import shadow.org.bouncycastle.util.Arrays;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper(new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.contentHelper);
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String string) {
        this.contentHelper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    private int getExpectedPayloadSize(PrivateKey privateKey) {
        if (privateKey instanceof DHKey) {
            DHKey dHKey = (DHKey)((Object)privateKey);
            return (dHKey.getParams().getP().bitLength() + 7) / 8;
        }
        if (privateKey instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)privateKey);
            return (rSAKey.getModulus().bitLength() + 7) / 8;
        }
        return -1;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privateKey) {
        return new AbstractPublicKeyDataDecryptorFactory(this){
            final int expectedPayLoadSize;
            final /* synthetic */ JcePublicKeyDataDecryptorFactoryBuilder this$0;
            {
                this.this$0 = jcePublicKeyDataDecryptorFactoryBuilder;
                this.expectedPayLoadSize = this.this$0.getExpectedPayloadSize(privateKey);
            }

            @Override
            public byte[] recoverSessionData(int n, byte[][] byArray, int n2) throws PGPException {
                if (n == 18 || n == 25 || n == 26) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return this.this$0.decryptSessionData(n, privateKey, this.expectedPayLoadSize, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return this.this$0.contentHelper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return this.this$0.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return this.this$0.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey pGPPrivateKey) {
        return new AbstractPublicKeyDataDecryptorFactory(this){
            final /* synthetic */ JcePublicKeyDataDecryptorFactoryBuilder this$0;
            {
                this.this$0 = jcePublicKeyDataDecryptorFactoryBuilder;
            }

            @Override
            public byte[] recoverSessionData(int n, byte[][] byArray, int n2) throws PGPException {
                boolean bl = this.containsSKAlg(n2);
                if (n == 18) {
                    return this.this$0.decryptSessionData(this.this$0.keyConverter, pGPPrivateKey, byArray);
                }
                if (n == 25) {
                    return this.this$0.decryptSessionData(this.this$0.keyConverter, pGPPrivateKey, byArray[0], 32, "X25519withSHA256HKDF", 7, EdECObjectIdentifiers.id_X25519, "X25519", bl);
                }
                if (n == 26) {
                    return this.this$0.decryptSessionData(this.this$0.keyConverter, pGPPrivateKey, byArray[0], 56, "X448withSHA512HKDF", 9, EdECObjectIdentifiers.id_X448, "X448", bl);
                }
                PrivateKey privateKey = this.this$0.keyConverter.getPrivateKey(pGPPrivateKey);
                int n3 = this.this$0.getExpectedPayloadSize(privateKey);
                return this.this$0.decryptSessionData(n, privateKey, n3, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return this.this$0.contentHelper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return this.this$0.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return this.this$0.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, byte[][] byArray) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        byte[] byArray2 = byArray[0];
        int n = (((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + 7) / 8;
        JcePublicKeyDataDecryptorFactoryBuilder.checkRange(2 + n + 1, byArray2);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        int n2 = byArray2[n + 2] & 0xFF;
        JcePublicKeyDataDecryptorFactoryBuilder.checkRange(2 + n + 1 + n2, byArray2);
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray2, 2 + n + 1, byArray4, 0, n2);
        try {
            Object object;
            Object object2;
            PublicKey publicKey;
            String string;
            ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
            if (JcaJcePGPUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                string = RFC6637Utils.getXDHAlgorithm(publicKeyPacket);
                if (byArray3.length != 33 || 64 != byArray3[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = this.getPublicKey(byArray3, EdECObjectIdentifiers.id_X25519, 1);
            } else if (eCDHPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_X448)) {
                string = RFC6637Utils.getXDHAlgorithm(publicKeyPacket);
                if (byArray3.length != 57 || 64 != byArray3[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = this.getPublicKey(byArray3, EdECObjectIdentifiers.id_X448, 1);
            } else {
                object2 = ECNamedCurveTable.getByOIDLazy(eCDHPublicBCPGKey.getCurveOID());
                object = ((X9ECParametersHolder)object2).getCurve().decodePoint(byArray3);
                string = RFC6637Utils.getAgreementAlgorithm(publicKeyPacket);
                publicKey = jcaPGPKeyConverter.getPublicKey(new PGPPublicKey(new PublicKeyPacket(publicKeyPacket.getVersion(), 18, new Date(), new ECDHPublicBCPGKey(eCDHPublicBCPGKey.getCurveOID(), (ECPoint)object, (int)eCDHPublicBCPGKey.getHashAlgorithm(), (int)eCDHPublicBCPGKey.getSymmetricKeyAlgorithm())), this.fingerprintCalculator));
            }
            object2 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, this.fingerprintCalculator);
            object = this.getSessionKey(jcaPGPKeyConverter, pGPPrivateKey, string, publicKey, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray4, new UserKeyingMaterialSpec((byte[])object2));
            return PGPPad.unpadSessionData(object.getEncoded());
        }
        catch (Exception exception) {
            throw new PGPException("error decrypting session data: " + exception.getMessage(), exception);
        }
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, byte[] byArray, int n, String string, int n2, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, boolean bl) throws PGPException {
        try {
            byte[] byArray2 = Arrays.copyOf(byArray, n);
            int n3 = byArray[n] & 0xFF;
            JcePublicKeyDataDecryptorFactoryBuilder.checkRange(n + 1 + n3, byArray);
            int n4 = n3 - (bl ? 1 : 0);
            int n5 = n + 1 + (bl ? 1 : 0);
            byte[] byArray3 = Arrays.copyOfRange(byArray, n5, n5 + n4);
            PublicKey publicKey = this.getPublicKey(byArray2, aSN1ObjectIdentifier, 0);
            Key key = this.getSessionKey(jcaPGPKeyConverter, pGPPrivateKey, string, publicKey, n2, byArray3, JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(byArray2, pGPPrivateKey.getPublicKeyPacket(), string2));
            return key.getEncoded();
        }
        catch (Exception exception) {
            throw new PGPException("error decrypting session data: " + exception.getMessage(), exception);
        }
    }

    private Key getSessionKey(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, String string, PublicKey publicKey, int n, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) throws PGPException, GeneralSecurityException {
        PrivateKey privateKey = jcaPGPKeyConverter.getPrivateKey(pGPPrivateKey);
        Key key = JcaJcePGPUtil.getSecret(this.helper, publicKey, RFC6637Utils.getKeyEncryptionOID(n).getId(), string, algorithmParameterSpec, privateKey);
        Cipher cipher = this.helper.createKeyWrapper(n);
        cipher.init(4, key);
        return cipher.unwrap(byArray, "Session", 3);
    }

    private PublicKey getPublicKey(byte[] byArray, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) throws PGPException, GeneralSecurityException, IOException {
        KeyFactory keyFactory = this.helper.createKeyFactory("XDH");
        return keyFactory.generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, n, byArray.length)).getEncoded()));
    }

    private void updateWithMPI(Cipher cipher, int n, byte[] byArray) {
        if (n > 0) {
            if (byArray.length - 2 > n) {
                cipher.update(byArray, 3, byArray.length - 3);
            } else {
                if (n > byArray.length - 2) {
                    cipher.update(new byte[n - (byArray.length - 2)]);
                }
                cipher.update(byArray, 2, byArray.length - 2);
            }
        } else {
            cipher.update(byArray, 2, byArray.length - 2);
        }
    }

    private byte[] decryptSessionData(int n, PrivateKey privateKey, int n2, byte[][] byArray) throws PGPException {
        Cipher cipher = this.helper.createPublicKeyCipher(n);
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        if (n == 2 || n == 1) {
            this.updateWithMPI(cipher, n2, byArray[0]);
        } else {
            this.updateWithMPI(cipher, n2, byArray[0]);
            this.updateWithMPI(cipher, n2, byArray[1]);
        }
        try {
            return cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting session data", exception);
        }
    }

    private static void checkRange(int n, byte[] byArray) throws PGPException {
        if (n > byArray.length) {
            throw new PGPException("encoded length out of range");
        }
    }
}

