/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import shadow.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import shadow.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shadow.org.bouncycastle.asn1.x9.X9ECParameters;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.crypto.ec.CustomNamedCurves;
import shadow.org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import shadow.org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import shadow.org.bouncycastle.math.ec.ECCurve;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.BigIntegers;
import shadow.org.bouncycastle.util.Strings;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string = PGPUtil.getSymmetricCipherName(n);
        if (string == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string);
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            return ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static HybridValueParameterSpec getHybridValueParameterSpecWithPrepend(byte[] byArray, PublicKeyPacket publicKeyPacket, String string) throws IOException {
        return new HybridValueParameterSpec(Arrays.concatenate(byArray, publicKeyPacket.getKey().getEncoded()), true, new UserKeyingMaterialSpec(Strings.toByteArray("OpenPGP " + string)));
    }

    static Key getSecret(OperatorHelper operatorHelper, PublicKey publicKey, String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, Key key) throws GeneralSecurityException {
        KeyAgreement keyAgreement = operatorHelper.createKeyAgreement(string2);
        keyAgreement.init(key, algorithmParameterSpec);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret(string);
    }

    static boolean isX25519(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.equals(CryptlibObjectIdentifiers.curvey25519) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519);
    }
}

