/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class JcaCFBSecretKeyEncryptorFactory
implements PBESecretKeyEncryptorFactory {
    private final int symmetricKeyAlgorithm;
    private final int iterationCount;
    private JcaPGPDigestCalculatorProviderBuilder digestCalcProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcePBESecretKeyEncryptorBuilder encBuilder;

    public JcaCFBSecretKeyEncryptorFactory(int n, int n2) throws PGPException {
        this.symmetricKeyAlgorithm = n;
        this.iterationCount = n2;
        this.encBuilder = this.builder();
    }

    public JcaCFBSecretKeyEncryptorFactory setProvider(Provider provider) throws PGPException {
        this.digestCalcProviderBuilder.setProvider(provider);
        this.encBuilder = this.builder();
        return this;
    }

    private JcePBESecretKeyEncryptorBuilder builder() throws PGPException {
        return new JcePBESecretKeyEncryptorBuilder(this.symmetricKeyAlgorithm, this.digestCalcProviderBuilder.build().get(2), this.iterationCount);
    }

    @Override
    public PBESecretKeyEncryptor build(char[] cArray, PublicKeyPacket publicKeyPacket) {
        if (cArray == null) {
            return null;
        }
        return this.encBuilder.build(cArray);
    }
}

