/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.InputStream;
import java.math.BigInteger;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import shadow.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import shadow.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shadow.org.bouncycastle.asn1.x9.X9ECParameters;
import shadow.org.bouncycastle.crypto.BlockCipher;
import shadow.org.bouncycastle.crypto.BufferedBlockCipher;
import shadow.org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import shadow.org.bouncycastle.crypto.InvalidCipherTextException;
import shadow.org.bouncycastle.crypto.RawAgreement;
import shadow.org.bouncycastle.crypto.ec.CustomNamedCurves;
import shadow.org.bouncycastle.crypto.io.CipherInputStream;
import shadow.org.bouncycastle.crypto.modes.CFBBlockCipher;
import shadow.org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.KeyParameter;
import shadow.org.bouncycastle.crypto.params.ParametersWithIV;
import shadow.org.bouncycastle.math.ec.ECCurve;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import shadow.org.bouncycastle.util.BigIntegers;

public class BcUtil {
    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = bl2 ? new DefaultBufferedBlockCipher(CFBBlockCipher.newInstance(blockCipher, blockCipher.getBlockSize() * 8)) : new DefaultBufferedBlockCipher(new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            ((BufferedBlockCipher)defaultBufferedBlockCipher).init(bl, new ParametersWithIV(keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            ((BufferedBlockCipher)defaultBufferedBlockCipher).init(bl, keyParameter);
        }
        return defaultBufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            @Override
            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = new DefaultBufferedBlockCipher(CFBBlockCipher.newInstance(blockCipher, blockCipher.getBlockSize() * 8));
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(bl, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        return defaultBufferedBlockCipher;
    }

    static byte[] processBufferedBlockCipher(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws InvalidCipherTextException {
        BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(bl, blockCipher, byArray, byArray2);
        byte[] byArray4 = new byte[n2];
        int n3 = bufferedBlockCipher.processBytes(byArray3, n, n2, byArray4, 0);
        n3 += bufferedBlockCipher.doFinal(byArray4, n3);
        return byArray4;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }

    static byte[] getSecret(RawAgreement rawAgreement, AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        rawAgreement.init(asymmetricKeyParameter);
        byte[] byArray = new byte[rawAgreement.getAgreementSize()];
        rawAgreement.calculateAgreement(asymmetricKeyParameter2, byArray, 0);
        return byArray;
    }

    static boolean isX25519(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.equals(CryptlibObjectIdentifiers.curvey25519) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519);
    }
}

