/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import shadow.org.bouncycastle.bcpg.AEADEncDataPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.crypto.BlockCipher;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPSessionKey;
import shadow.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import shadow.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcSessionKeyDataDecryptorFactory
implements SessionKeyDataDecryptorFactory {
    private final PGPSessionKey sessionKey;

    public BcSessionKeyDataDecryptorFactory(PGPSessionKey pGPSessionKey) {
        this.sessionKey = pGPSessionKey;
    }

    @Override
    public PGPSessionKey getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

