/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import shadow.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import shadow.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.MPInteger;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shadow.org.bouncycastle.crypto.KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.RawAgreement;
import shadow.org.bouncycastle.crypto.Wrapper;
import shadow.org.bouncycastle.crypto.agreement.BasicRawAgreement;
import shadow.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import shadow.org.bouncycastle.crypto.agreement.X25519Agreement;
import shadow.org.bouncycastle.crypto.agreement.X448Agreement;
import shadow.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.KeyParameter;
import shadow.org.bouncycastle.crypto.params.ParametersWithRandom;
import shadow.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.operator.PGPPad;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.RFC6637Utils;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;
import shadow.org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import shadow.org.bouncycastle.util.Arrays;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray, byte by, boolean bl) throws PGPException {
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
            PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
            if (pGPPublicKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                byte[] byArray2 = this.createSessionInfo(bl ? by : (byte)0, byArray);
                byte[] byArray3 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, new BcKeyFingerprintCalculator());
                if (BcUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair(new X25519KeyPairGenerator(), new X25519KeyGenerationParameters(this.random));
                    byte[] byArray4 = BcUtil.getSecret(new X25519Agreement(), asymmetricCipherKeyPair.getPrivate(), asymmetricKeyParameter);
                    byte[] byArray5 = new byte[33];
                    byArray5[0] = 64;
                    ((X25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).encode(byArray5, 1);
                    return this.encryptSessionInfoWithECDHKey(byArray2, byArray4, byArray3, byArray5, eCDHPublicBCPGKey.getHashAlgorithm(), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
                }
                if (eCDHPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_X448)) {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair(new X448KeyPairGenerator(), new X448KeyGenerationParameters(this.random));
                    byte[] byArray6 = BcUtil.getSecret(new X448Agreement(), asymmetricCipherKeyPair.getPrivate(), asymmetricKeyParameter);
                    byte[] byArray7 = new byte[57];
                    byArray7[0] = 64;
                    ((X448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).encode(byArray7, 1);
                    return this.encryptSessionInfoWithECDHKey(byArray2, byArray6, byArray3, byArray7, eCDHPublicBCPGKey.getHashAlgorithm(), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
                }
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair(new ECKeyPairGenerator(), new ECKeyGenerationParameters(((ECPublicKeyParameters)asymmetricKeyParameter).getParameters(), this.random));
                byte[] byArray8 = BcUtil.getSecret(new BasicRawAgreement(new ECDHBasicAgreement()), asymmetricCipherKeyPair.getPrivate(), asymmetricKeyParameter);
                byte[] byArray9 = ((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getQ().getEncoded(false);
                return this.encryptSessionInfoWithECDHKey(byArray2, byArray8, byArray3, byArray9, eCDHPublicBCPGKey.getHashAlgorithm(), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            }
            if (pGPPublicKey.getAlgorithm() == 25) {
                return this.encryptSessionInfoWithX25519X448Key(publicKeyPacket, byArray, 8, 7, "X25519", new X25519KeyPairGenerator(), new X25519KeyGenerationParameters(this.random), new X25519Agreement(), asymmetricKeyParameter, 32, new EphPubEncodingOperation(){

                    @Override
                    public void getEphPubEncoding(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
                        ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                    }
                }, bl ? by : (byte)0);
            }
            if (pGPPublicKey.getAlgorithm() == 26) {
                return this.encryptSessionInfoWithX25519X448Key(publicKeyPacket, byArray, 10, 9, "X448", new X448KeyPairGenerator(), new X448KeyGenerationParameters(this.random), new X448Agreement(), asymmetricKeyParameter, 56, new EphPubEncodingOperation(){

                    @Override
                    public void getEphPubEncoding(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
                        ((X448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                    }
                }, bl ? by : (byte)0);
            }
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
            byte[] byArray10 = this.createSessionInfo(bl ? by : (byte)0, byArray);
            return asymmetricBlockCipher.processBlock(byArray10, 0, byArray10.length);
        }
        catch (Exception exception) {
            throw new PGPException("exception encrypting session info: " + exception.getMessage(), exception);
        }
    }

    private byte[] encryptSessionInfoWithECDHKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) throws IOException, PGPException {
        RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(n), n2);
        KeyParameter keyParameter = new KeyParameter(rFC6637KDFCalculator.createKey(byArray2, byArray3));
        byte[] byArray5 = PGPPad.padSessionData(byArray, this.sessionKeyObfuscation);
        return BcPublicKeyKeyEncryptionMethodGenerator.getSessionInfo(new MPInteger(new BigInteger(1, byArray4)).getEncoded(), (byte)0, this.getWrapper(n2, keyParameter, byArray5));
    }

    private byte[] encryptSessionInfoWithX25519X448Key(PublicKeyPacket publicKeyPacket, byte[] byArray, int n, int n2, String string, AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator, KeyGenerationParameters keyGenerationParameters, RawAgreement rawAgreement, AsymmetricKeyParameter asymmetricKeyParameter, int n3, EphPubEncodingOperation ephPubEncodingOperation, byte by) throws PGPException {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair(asymmetricCipherKeyPairGenerator, keyGenerationParameters);
        byte[] byArray2 = BcUtil.getSecret(rawAgreement, asymmetricCipherKeyPair.getPrivate(), asymmetricKeyParameter);
        byte[] byArray3 = new byte[n3];
        ephPubEncodingOperation.getEphPubEncoding(asymmetricCipherKeyPair.getPublic(), byArray3);
        KeyParameter keyParameter = new KeyParameter(RFC6637KDFCalculator.createKey(n, n2, Arrays.concatenate(byArray3, publicKeyPacket.getKey().getEncoded(), byArray2), "OpenPGP " + string));
        return BcPublicKeyKeyEncryptionMethodGenerator.getSessionInfo(byArray3, by, this.getWrapper(n2, keyParameter, byArray));
    }

    private byte[] getWrapper(int n, KeyParameter keyParameter, byte[] byArray) throws PGPException {
        Wrapper wrapper = BcImplProvider.createWrapper(n);
        wrapper.init(true, new ParametersWithRandom(keyParameter, this.random));
        return wrapper.wrap(byArray, 0, byArray.length);
    }

    private AsymmetricCipherKeyPair getAsymmetricCipherKeyPair(AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator, KeyGenerationParameters keyGenerationParameters) {
        asymmetricCipherKeyPairGenerator.init(keyGenerationParameters);
        return asymmetricCipherKeyPairGenerator.generateKeyPair();
    }

    @FunctionalInterface
    private static interface EphPubEncodingOperation {
        public void getEphPubEncoding(AsymmetricKeyParameter var1, byte[] var2);
    }
}

