/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shadow.org.bouncycastle.asn1.x9.X9ECParameters;
import shadow.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shadow.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shadow.org.bouncycastle.crypto.ec.CustomNamedCurves;
import shadow.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import shadow.org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import shadow.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import shadow.org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import shadow.org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPKeyPair;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;

public class BcPGPKeyPairGeneratorProvider
extends PGPKeyPairGeneratorProvider {
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();

    @Override
    public PGPKeyPairGenerator get(int n, Date date) {
        return new BcPGPKeyPairGenerator(n, date, this.random);
    }

    public BcPGPKeyPairGeneratorProvider setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    private static X9ECParameters getNamedCurveByOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    private static class BcPGPKeyPairGenerator
    extends PGPKeyPairGenerator {
        public BcPGPKeyPairGenerator(int n, Date date, SecureRandom secureRandom) {
            super(n, date, secureRandom, new BcKeyFingerprintCalculator());
        }

        @Override
        public PGPKeyPair generateRsaKeyPair(BigInteger bigInteger, int n) throws PGPException {
            RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
            rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(bigInteger, this.random, n, 100));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 1, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateEd25519KeyPair() throws PGPException {
            Ed25519KeyPairGenerator ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
            ed25519KeyPairGenerator.init(new Ed25519KeyGenerationParameters(this.random));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = ed25519KeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 27, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateEd448KeyPair() throws PGPException {
            Ed448KeyPairGenerator ed448KeyPairGenerator = new Ed448KeyPairGenerator();
            ed448KeyPairGenerator.init(new Ed448KeyGenerationParameters(this.random));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = ed448KeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 28, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateX25519KeyPair() throws PGPException {
            X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
            x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(this.random));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = x25519KeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 25, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateX448KeyPair() throws PGPException {
            X448KeyPairGenerator x448KeyPairGenerator = new X448KeyPairGenerator();
            x448KeyPairGenerator.init(new X448KeyGenerationParameters(this.random));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = x448KeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 26, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateLegacyEd25519KeyPair() throws PGPException {
            if (this.version == 6) {
                throw new PGPException("An implementation MUST NOT generate a v6 LegacyEd25519 key pair.");
            }
            Ed25519KeyPairGenerator ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
            ed25519KeyPairGenerator.init(new Ed25519KeyGenerationParameters(this.random));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = ed25519KeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 22, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateLegacyX25519KeyPair() throws PGPException {
            if (this.version == 6) {
                throw new PGPException("An implementation MUST NOT generate a v6 LegacyX25519 key pair.");
            }
            X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
            x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(this.random));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = x25519KeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 18, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateECDHKeyPair(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws PGPException {
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(new ECNamedDomainParameters(aSN1ObjectIdentifier, BcPGPKeyPairGeneratorProvider.getNamedCurveByOid(aSN1ObjectIdentifier)), CryptoServicesRegistrar.getSecureRandom()));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 18, asymmetricCipherKeyPair, this.creationTime);
        }

        @Override
        public PGPKeyPair generateECDSAKeyPair(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws PGPException {
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(new ECKeyGenerationParameters(new ECNamedDomainParameters(aSN1ObjectIdentifier, BcPGPKeyPairGeneratorProvider.getNamedCurveByOid(aSN1ObjectIdentifier)), CryptoServicesRegistrar.getSecureRandom()));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            return new BcPGPKeyPair(this.version, 19, asymmetricCipherKeyPair, this.creationTime);
        }
    }
}

