/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import shadow.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import shadow.org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.asn1.x9.X9ECParameters;
import shadow.org.bouncycastle.bcpg.BCPGKey;
import shadow.org.bouncycastle.bcpg.DSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.DSASecretBCPGKey;
import shadow.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ECPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ECSecretBCPGKey;
import shadow.org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import shadow.org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import shadow.org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import shadow.org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import shadow.org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.EdSecretBCPGKey;
import shadow.org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import shadow.org.bouncycastle.bcpg.OctetArrayBCPGKey;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import shadow.org.bouncycastle.bcpg.RSASecretBCPGKey;
import shadow.org.bouncycastle.bcpg.X25519PublicBCPGKey;
import shadow.org.bouncycastle.bcpg.X25519SecretBCPGKey;
import shadow.org.bouncycastle.bcpg.X448PublicBCPGKey;
import shadow.org.bouncycastle.bcpg.X448SecretBCPGKey;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.DSAParameters;
import shadow.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.ECDomainParameters;
import shadow.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import shadow.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.ElGamalParameters;
import shadow.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.RSAKeyParameters;
import shadow.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import shadow.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import shadow.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import shadow.org.bouncycastle.crypto.util.PrivateKeyFactory;
import shadow.org.bouncycastle.crypto.util.PublicKeyFactory;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPKdfParameters;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.BigIntegers;

public class BcPGPKeyConverter
extends PGPKeyConverter {
    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BCPGKey bCPGKey = this.getPrivateBCPGKey(pGPPublicKey, asymmetricKeyParameter);
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), bCPGKey);
    }

    @Deprecated
    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        return this.getPGPPublicKey(4, n, pGPAlgorithmParameters, asymmetricKeyParameter, date);
    }

    public PGPPublicKey getPGPPublicKey(int n, int n2, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        BCPGKey bCPGKey = this.getPublicBCPGKey(n2, pGPAlgorithmParameters, asymmetricKeyParameter);
        return new PGPPublicKey(new PublicKeyPacket(n, n2, date, bCPGKey), new BcKeyFingerprintCalculator());
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    return new DSAPrivateKeyParameters(dSASecretBCPGKey.getX(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (BcUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(((ECSecretBCPGKey)bCPGKey).getX()))));
                    }
                    if (EdECObjectIdentifiers.id_X448.equals(eCDHPublicBCPGKey.getCurveOID())) {
                        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(((ECSecretBCPGKey)bCPGKey).getX()))));
                    }
                    return this.implGetPrivateKeyEC(eCDHPublicBCPGKey, (ECSecretBCPGKey)bCPGKey);
                }
                case 25: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, bCPGKey.getEncoded()));
                }
                case 26: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, bCPGKey.getEncoded()));
                }
                case 19: {
                    return this.implGetPrivateKeyEC((ECDSAPublicBCPGKey)publicKeyPacket.getKey(), (ECSecretBCPGKey)bCPGKey);
                }
                case 22: {
                    if (((EdDSAPublicBCPGKey)publicKeyPacket.getKey()).getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed448, 57, bCPGKey);
                    }
                    return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed25519, 32, bCPGKey);
                }
                case 27: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, bCPGKey.getEncoded()));
                }
                case 28: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, bCPGKey.getEncoded()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    return new ElGamalPrivateKeyParameters(elGamalSecretBCPGKey.getX(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    return new RSAPrivateCrtKeyParameters(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new DSAPublicKeyParameters(dSAPublicBCPGKey.getY(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (BcUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                        byte[] byArray = BigIntegers.asUnsignedByteArray(eCDHPublicBCPGKey.getEncodedPoint());
                        if (byArray.length < 1 || 64 != byArray[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_X25519, byArray, 1);
                    }
                    if (eCDHPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_X448)) {
                        byte[] byArray = BigIntegers.asUnsignedByteArray(eCDHPublicBCPGKey.getEncodedPoint());
                        if (byArray.length < 1 || 64 != byArray[0]) {
                            throw new IllegalArgumentException("Invalid X448 public key");
                        }
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_X448, byArray, 1);
                    }
                    return this.implGetPublicKeyEC(eCDHPublicBCPGKey);
                }
                case 25: {
                    return this.implGetPublicKeyX509((X25519PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_X25519);
                }
                case 26: {
                    return this.implGetPublicKeyX509((X448PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_X448);
                }
                case 19: {
                    return this.implGetPublicKeyEC((ECDSAPublicBCPGKey)publicKeyPacket.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    byte[] byArray = BigIntegers.asUnsignedByteArray(edDSAPublicBCPGKey.getEncodedPoint());
                    if (byArray.length < 1) {
                        throw new IllegalArgumentException("Invalid EdDSA public key");
                    }
                    if (!edDSAPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed25519, byArray, byArray[0] == 64 ? 1 : 0);
                    }
                    if (edDSAPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed448, byArray, byArray[0] == 64 ? 1 : 0);
                    }
                    throw new IllegalArgumentException("Invalid EdDSA public key");
                }
                case 27: {
                    return this.implGetPublicKeyX509((Ed25519PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_Ed25519);
                }
                case 28: {
                    return this.implGetPublicKeyX509((Ed448PublicBCPGKey)publicKeyPacket.getKey(), EdECObjectIdentifiers.id_Ed448);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    return new ElGamalPublicKeyParameters(elGamalPublicBCPGKey.getY(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new RSAKeyParameters(false, rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + pGPPublicKey.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        switch (pGPPublicKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                return new DSASecretBCPGKey(dSAPrivateKeyParameters.getX());
            }
            case 18: {
                if (asymmetricKeyParameter instanceof X25519PrivateKeyParameters) {
                    return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverseInPlace(((X25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded())));
                }
                if (asymmetricKeyParameter instanceof X448PrivateKeyParameters) {
                    return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverseInPlace(((X448PrivateKeyParameters)asymmetricKeyParameter).getEncoded())));
                }
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                return new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
            }
            case 25: {
                return new X25519SecretBCPGKey(((X25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            case 26: {
                return new X448SecretBCPGKey(((X448PrivateKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            case 19: {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
                return new ECSecretBCPGKey(eCPrivateKeyParameters.getD());
            }
            case 22: {
                if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
                    return new EdSecretBCPGKey(new BigInteger(1, ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded()));
                }
                return new EdSecretBCPGKey(new BigInteger(1, ((Ed448PrivateKeyParameters)asymmetricKeyParameter).getEncoded()));
            }
            case 27: {
                return new Ed25519SecretBCPGKey(((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            case 28: {
                return new Ed448SecretBCPGKey(((Ed448PrivateKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                return new ElGamalSecretBCPGKey(elGamalPrivateKeyParameters.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
                return new RSASecretBCPGKey(rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ());
            }
        }
        throw new PGPException("unknown public key algorithm encountered: " + pGPPublicKey.getAlgorithm());
    }

    private BCPGKey getPublicBCPGKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
                return new RSAPublicBCPGKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
            }
            case 17: {
                DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
                DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
                return new DSAPublicBCPGKey(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG(), dSAPublicKeyParameters.getY());
            }
            case 16: 
            case 20: {
                ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricKeyParameter;
                ElGamalParameters elGamalParameters = elGamalPublicKeyParameters.getParameters();
                return new ElGamalPublicBCPGKey(elGamalParameters.getP(), elGamalParameters.getG(), elGamalPublicKeyParameters.getY());
            }
            case 18: {
                if (asymmetricKeyParameter instanceof X25519PublicKeyParameters) {
                    byte[] byArray = new byte[33];
                    byArray[0] = 64;
                    ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
                    PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, pGPAlgorithmParameters);
                    return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, byArray), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
                }
                if (asymmetricKeyParameter instanceof X448PublicKeyParameters) {
                    byte[] byArray = new byte[57];
                    byArray[0] = 64;
                    ((X448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
                    PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(EdECObjectIdentifiers.id_X448, pGPAlgorithmParameters);
                    return new ECDHPublicBCPGKey(EdECObjectIdentifiers.id_X448, new BigInteger(1, byArray), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
                }
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
                ECNamedDomainParameters eCNamedDomainParameters = (ECNamedDomainParameters)eCPublicKeyParameters.getParameters();
                PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(eCNamedDomainParameters.getName(), pGPAlgorithmParameters);
                return new ECDHPublicBCPGKey(eCNamedDomainParameters.getName(), eCPublicKeyParameters.getQ(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            }
            case 19: {
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
                ECNamedDomainParameters eCNamedDomainParameters = (ECNamedDomainParameters)eCPublicKeyParameters.getParameters();
                return new ECDSAPublicBCPGKey(eCNamedDomainParameters.getName(), eCPublicKeyParameters.getQ());
            }
            case 22: {
                if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
                    byte[] byArray = new byte[33];
                    byArray[0] = 64;
                    ((Ed25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
                    return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, byArray));
                }
                if (asymmetricKeyParameter instanceof Ed448PublicKeyParameters) {
                    byte[] byArray = new byte[58];
                    byArray[0] = 64;
                    ((Ed448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 1);
                    return new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed448, new BigInteger(1, byArray));
                }
                throw new PGPException("Unknown LegacyEdDSA key type: " + asymmetricKeyParameter.getClass().getName());
            }
            case 27: {
                byte[] byArray = new byte[32];
                ((Ed25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                return new Ed25519PublicBCPGKey(byArray);
            }
            case 28: {
                byte[] byArray = new byte[57];
                ((Ed448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                return new Ed448PublicBCPGKey(byArray);
            }
            case 25: {
                byte[] byArray = new byte[32];
                ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                return new X25519PublicBCPGKey(byArray);
            }
            case 26: {
                byte[] byArray = new byte[56];
                ((X448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                return new X448PublicBCPGKey(byArray);
            }
        }
        throw new PGPException("unknown public key algorithm encountered: " + n);
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(OctetArrayBCPGKey octetArrayBCPGKey, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        byte[] byArray = Arrays.clone(octetArrayBCPGKey.getKey());
        return PublicKeyFactory.createKey(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, 0, byArray.length)));
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n) throws IOException {
        return PublicKeyFactory.createKey(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange(byArray, n, byArray.length)));
    }

    private ECNamedDomainParameters implGetParametersEC(ECPublicBCPGKey eCPublicBCPGKey) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        X9ECParameters x9ECParameters = BcUtil.getX9Parameters(aSN1ObjectIdentifier);
        return new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    private AsymmetricKeyParameter implGetPrivateKeyEC(ECPublicBCPGKey eCPublicBCPGKey, ECSecretBCPGKey eCSecretBCPGKey) throws PGPException {
        ECNamedDomainParameters eCNamedDomainParameters = this.implGetParametersEC(eCPublicBCPGKey);
        return new ECPrivateKeyParameters(eCSecretBCPGKey.getX(), (ECDomainParameters)eCNamedDomainParameters);
    }

    private AsymmetricKeyParameter implGetPrivateKeyPKCS8(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, BCPGKey bCPGKey) throws IOException {
        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(aSN1ObjectIdentifier, BigIntegers.asUnsignedByteArray(n, ((EdSecretBCPGKey)bCPGKey).getX())));
    }

    private AsymmetricKeyParameter implGetPublicKeyEC(ECPublicBCPGKey eCPublicBCPGKey) throws PGPException {
        ECNamedDomainParameters eCNamedDomainParameters = this.implGetParametersEC(eCPublicBCPGKey);
        ECPoint eCPoint = BcUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), eCNamedDomainParameters.getCurve());
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)eCNamedDomainParameters);
    }
}

