/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import shadow.org.bouncycastle.crypto.Signer;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import shadow.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import shadow.org.bouncycastle.openpgp.operator.bc.SignerOutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    @Override
    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new BcPGPContentVerifierBuilder(n, n2);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        @Override
        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            AsymmetricKeyParameter asymmetricKeyParameter = BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey);
            final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, asymmetricKeyParameter);
            signer.init(false, asymmetricKeyParameter);
            return new PGPContentVerifier(){
                final /* synthetic */ BcPGPContentVerifierBuilder this$1;
                {
                    this.this$1 = bcPGPContentVerifierBuilder;
                }

                @Override
                public int getHashAlgorithm() {
                    return this.this$1.hashAlgorithm;
                }

                @Override
                public int getKeyAlgorithm() {
                    return this.this$1.keyAlgorithm;
                }

                @Override
                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                @Override
                public boolean verify(byte[] byArray) {
                    return signer.verifySignature(byArray);
                }

                @Override
                public OutputStream getOutputStream() {
                    return new SignerOutputStream(signer);
                }
            };
        }
    }
}

