/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import shadow.org.bouncycastle.crypto.InvalidCipherTextException;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPBESecretKeyDecryptorBuilder
implements PBESecretKeyDecryptorBuilder {
    private PGPDigestCalculatorProvider calculatorProvider;

    public BcPBESecretKeyDecryptorBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    @Override
    public PBESecretKeyDecryptor build(char[] cArray) {
        return new PBESecretKeyDecryptor(cArray, this.calculatorProvider){

            @Override
            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    return BcUtil.processBufferedBlockCipher(false, BcImplProvider.createBlockCipher(n), byArray, byArray2, byArray3, n2, n3);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("decryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
            }

            @Override
            public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                return BcAEADUtil.processAeadKeyData(false, n, n2, byArray, byArray2, n3, n4, byArray3, 0, byArray3.length, byArray4);
            }
        };
    }
}

