/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import shadow.org.bouncycastle.bcpg.S2K;
import shadow.org.bouncycastle.bcpg.SymmetricKeyUtils;
import shadow.org.bouncycastle.crypto.BlockCipher;
import shadow.org.bouncycastle.crypto.InvalidCipherTextException;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import shadow.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcUtil;
import shadow.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        super(cArray, argon2Params);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
            return BcUtil.processBufferedBlockCipher(true, blockCipher, byArray, new byte[blockCipher.getBlockSize()], byArray2, 0, byArray2.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("encryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    @Override
    protected byte[] generateV6KEK(int n, byte[] byArray, byte[] byArray2) {
        return BcAEADUtil.generateHKDFBytes(byArray, null, byArray2, SymmetricKeyUtils.getKeyLengthInOctets(n));
    }

    @Override
    protected byte[] getEskAndTag(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws PGPException {
        return BcAEADUtil.processAEADData(true, n, n2, byArray2, byArray3, byArray4, byArray, 0, byArray.length, "cannot encrypt session info");
    }
}

