/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import shadow.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shadow.org.bouncycastle.crypto.BlockCipher;
import shadow.org.bouncycastle.crypto.CipherParameters;
import shadow.org.bouncycastle.crypto.CryptoException;
import shadow.org.bouncycastle.crypto.DataLengthException;
import shadow.org.bouncycastle.crypto.Digest;
import shadow.org.bouncycastle.crypto.Signer;
import shadow.org.bouncycastle.crypto.Wrapper;
import shadow.org.bouncycastle.crypto.digests.MD2Digest;
import shadow.org.bouncycastle.crypto.digests.MD5Digest;
import shadow.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import shadow.org.bouncycastle.crypto.digests.SHA1Digest;
import shadow.org.bouncycastle.crypto.digests.SHA224Digest;
import shadow.org.bouncycastle.crypto.digests.SHA256Digest;
import shadow.org.bouncycastle.crypto.digests.SHA384Digest;
import shadow.org.bouncycastle.crypto.digests.SHA3Digest;
import shadow.org.bouncycastle.crypto.digests.SHA512Digest;
import shadow.org.bouncycastle.crypto.digests.TigerDigest;
import shadow.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import shadow.org.bouncycastle.crypto.engines.AESEngine;
import shadow.org.bouncycastle.crypto.engines.BlowfishEngine;
import shadow.org.bouncycastle.crypto.engines.CAST5Engine;
import shadow.org.bouncycastle.crypto.engines.CamelliaEngine;
import shadow.org.bouncycastle.crypto.engines.DESEngine;
import shadow.org.bouncycastle.crypto.engines.DESedeEngine;
import shadow.org.bouncycastle.crypto.engines.ElGamalEngine;
import shadow.org.bouncycastle.crypto.engines.IDEAEngine;
import shadow.org.bouncycastle.crypto.engines.RFC3394WrapEngine;
import shadow.org.bouncycastle.crypto.engines.RSABlindedEngine;
import shadow.org.bouncycastle.crypto.engines.TwofishEngine;
import shadow.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import shadow.org.bouncycastle.crypto.signers.DSADigestSigner;
import shadow.org.bouncycastle.crypto.signers.DSASigner;
import shadow.org.bouncycastle.crypto.signers.ECDSASigner;
import shadow.org.bouncycastle.crypto.signers.Ed25519Signer;
import shadow.org.bouncycastle.crypto.signers.Ed448Signer;
import shadow.org.bouncycastle.crypto.signers.RSADigestSigner;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.util.Arrays;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int n) throws PGPException {
        switch (n) {
            case 2: {
                return new SHA1Digest();
            }
            case 11: {
                return new SHA224Digest();
            }
            case 8: {
                return new SHA256Digest();
            }
            case 9: {
                return new SHA384Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
            case 312: {
                return new SHA3Digest(224);
            }
            case 12: 
            case 313: {
                return new SHA3Digest(256);
            }
            case 314: {
                return new SHA3Digest(384);
            }
            case 14: 
            case 315: {
                return new SHA3Digest(512);
            }
            case 5: {
                return new MD2Digest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 3: {
                return new RIPEMD160Digest();
            }
            case 6: {
                return new TigerDigest();
            }
        }
        throw new PGPException("cannot recognise digest");
    }

    static Signer createSigner(int n, int n2, CipherParameters cipherParameters) throws PGPException {
        switch (n) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(n2));
            }
            case 17: {
                return new DSADigestSigner(new DSASigner(), BcImplProvider.createDigest(n2));
            }
            case 19: {
                return new DSADigestSigner(new ECDSASigner(), BcImplProvider.createDigest(n2));
            }
            case 22: {
                if (cipherParameters instanceof Ed25519PrivateKeyParameters || cipherParameters instanceof Ed25519PublicKeyParameters) {
                    return new EdDsaSigner(new Ed25519Signer(), BcImplProvider.createDigest(n2));
                }
                return new EdDsaSigner(new Ed448Signer(new byte[0]), BcImplProvider.createDigest(n2));
            }
            case 27: {
                return new EdDsaSigner(new Ed25519Signer(), BcImplProvider.createDigest(n2));
            }
            case 28: {
                return new EdDsaSigner(new Ed448Signer(new byte[0]), BcImplProvider.createDigest(n2));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + n);
    }

    static BlockCipher createBlockCipher(int n) throws PGPException {
        BlockCipher blockCipher;
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                blockCipher = AESEngine.newInstance();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                blockCipher = new CamelliaEngine();
                break;
            }
            case 4: {
                blockCipher = new BlowfishEngine();
                break;
            }
            case 3: {
                blockCipher = new CAST5Engine();
                break;
            }
            case 6: {
                blockCipher = new DESEngine();
                break;
            }
            case 1: {
                blockCipher = new IDEAEngine();
                break;
            }
            case 10: {
                blockCipher = new TwofishEngine();
                break;
            }
            case 2: {
                blockCipher = new DESedeEngine();
                break;
            }
            default: {
                throw new PGPException("cannot recognise cipher");
            }
        }
        return blockCipher;
    }

    static Wrapper createWrapper(int n) throws PGPException {
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                return new RFC3394WrapEngine(AESEngine.newInstance());
            }
            case 11: 
            case 12: 
            case 13: {
                return new RFC3394WrapEngine(new CamelliaEngine());
            }
        }
        throw new PGPException("unknown wrap algorithm: " + n);
    }

    static AsymmetricBlockCipher createPublicKeyCipher(int n) throws PGPException {
        PKCS1Encoding pKCS1Encoding;
        switch (n) {
            case 1: 
            case 2: {
                pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
                break;
            }
            case 16: 
            case 20: {
                pKCS1Encoding = new PKCS1Encoding(new ElGamalEngine());
                break;
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 18: 
            case 25: 
            case 26: {
                throw new PGPException("Not implemented.");
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + n);
            }
        }
        return pKCS1Encoding;
    }

    private static class EdDsaSigner
    implements Signer {
        private final Signer signer;
        private final Digest digest;
        private final byte[] digBuf;

        EdDsaSigner(Signer signer, Digest digest) {
            this.signer = signer;
            this.digest = digest;
            this.digBuf = new byte[digest.getDigestSize()];
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) {
            this.signer.init(bl, cipherParameters);
            this.digest.reset();
        }

        @Override
        public void update(byte by) {
            this.digest.update(by);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.digest.update(byArray, n, n2);
        }

        @Override
        public byte[] generateSignature() throws CryptoException, DataLengthException {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.generateSignature();
        }

        @Override
        public boolean verifySignature(byte[] byArray) {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.verifySignature(byArray);
        }

        @Override
        public void reset() {
            Arrays.clear(this.digBuf);
            this.signer.reset();
            this.digest.reset();
        }
    }
}

