/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator.bc;

import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public class BcCFBSecretKeyEncryptorFactory
implements PBESecretKeyEncryptorFactory {
    private final int symmetricKeyAlgorithm;
    private final int iterationCount;

    public BcCFBSecretKeyEncryptorFactory(int n, int n2) {
        this.symmetricKeyAlgorithm = n;
        this.iterationCount = n2;
    }

    @Override
    public PBESecretKeyEncryptor build(char[] cArray, PublicKeyPacket publicKeyPacket) {
        PGPDigestCalculator pGPDigestCalculator;
        if (cArray == null) {
            return null;
        }
        try {
            pGPDigestCalculator = new BcPGPDigestCalculatorProvider().get(8);
        }
        catch (PGPException pGPException) {
            throw new RuntimeException(pGPException);
        }
        return new BcPBESecretKeyEncryptorBuilder(this.symmetricKeyAlgorithm, pGPDigestCalculator, this.iterationCount).build(cArray);
    }
}

