/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.io.OutputStream;
import shadow.org.bouncycastle.bcpg.HashAlgorithmTags;
import shadow.org.bouncycastle.bcpg.S2K;
import shadow.org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import shadow.org.bouncycastle.crypto.params.Argon2Parameters;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.util.Strings;

class PGPUtil
implements HashAlgorithmTags {
    PGPUtil() {
    }

    static byte[] makeKeyFromPassPhrase(PGPDigestCalculator pGPDigestCalculator, int n, S2K s2K, char[] cArray) throws PGPException {
        int n2;
        switch (n) {
            case 2: 
            case 8: 
            case 12: {
                n2 = 192;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                n2 = 128;
                break;
            }
            case 6: {
                n2 = 64;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                n2 = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = Strings.toUTF8ByteArray(cArray);
        byte[] byArray2 = new byte[(n2 + 7) / 8];
        int n3 = 0;
        int n4 = 0;
        if (s2K != null) {
            if (s2K.getType() == 4) {
                Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withSalt(s2K.getIV()).withIterations(s2K.getPasses()).withParallelism(s2K.getParallelism()).withMemoryPowOfTwo(s2K.getMemorySizeExponent()).withVersion(19);
                Argon2BytesGenerator argon2BytesGenerator = new Argon2BytesGenerator();
                argon2BytesGenerator.init(builder.build());
                argon2BytesGenerator.generateBytes(cArray, byArray2);
                return byArray2;
            }
            if (s2K.getHashAlgorithm() != pGPDigestCalculator.getAlgorithm()) {
                throw new PGPException("s2k/digestCalculator mismatch");
            }
        } else if (pGPDigestCalculator.getAlgorithm() != 1) {
            throw new PGPException("digestCalculator not for MD5");
        }
        OutputStream outputStream = pGPDigestCalculator.getOutputStream();
        try {
            byte[] byArray3;
            byte[] byArray4 = byArray3 = s2K != null ? s2K.getIV() : null;
            while (n3 < byArray2.length) {
                block24: {
                    block25: {
                        for (int i = 0; i != n4; ++i) {
                            outputStream.write(0);
                        }
                        if (s2K == null) break block25;
                        switch (s2K.getType()) {
                            case 0: {
                                outputStream.write(byArray);
                                break block24;
                            }
                            case 1: {
                                outputStream.write(byArray3);
                                outputStream.write(byArray);
                                break block24;
                            }
                            case 3: {
                                long l = s2K.getIterationCount();
                                outputStream.write(byArray3);
                                outputStream.write(byArray);
                                l -= (long)(byArray3.length + byArray.length);
                                while (l > 0L) {
                                    if (l < (long)byArray3.length) {
                                        outputStream.write(byArray3, 0, (int)l);
                                        break block24;
                                    }
                                    outputStream.write(byArray3);
                                    if ((l -= (long)byArray3.length) < (long)byArray.length) {
                                        outputStream.write(byArray, 0, (int)l);
                                        l = 0L;
                                        continue;
                                    }
                                    outputStream.write(byArray);
                                    l -= (long)byArray.length;
                                }
                                break block24;
                            }
                            default: {
                                throw new PGPException("unknown S2K type: " + s2K.getType());
                            }
                        }
                    }
                    outputStream.write(byArray);
                }
                outputStream.close();
                byte[] byArray5 = pGPDigestCalculator.getDigest();
                int n5 = Math.min(byArray5.length, byArray2.length - n3);
                System.arraycopy(byArray5, 0, byArray2, n3, n5);
                n3 += n5;
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new PGPException("exception calculating digest: " + iOException.getMessage(), iOException);
        }
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
        return byArray2;
    }

    public static byte[] makeKeyFromPassPhrase(PGPDigestCalculatorProvider pGPDigestCalculatorProvider, int n, S2K s2K, char[] cArray) throws PGPException {
        PGPDigestCalculator pGPDigestCalculator = s2K != null && s2K.getType() != 4 ? pGPDigestCalculatorProvider.get(s2K.getHashAlgorithm()) : pGPDigestCalculatorProvider.get(1);
        return PGPUtil.makeKeyFromPassPhrase(pGPDigestCalculator, n, s2K, cArray);
    }
}

