/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api.jcajce;

import java.io.InputStream;
import java.security.Provider;
import java.security.SecureRandom;
import shadow.org.bouncycastle.bcpg.S2K;
import shadow.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shadow.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPObjectFactory;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSessionKey;
import shadow.org.bouncycastle.openpgp.api.OpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaAEADSecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaCFBSecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPairGeneratorProvider;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JceSessionKeyDataDecryptorFactoryBuilder;

public class JcaOpenPGPImplementation
extends OpenPGPImplementation {
    private final Provider provider;
    private final SecureRandom secureRandom;

    public JcaOpenPGPImplementation() {
        this(new BouncyCastleProvider(), CryptoServicesRegistrar.getSecureRandom());
    }

    public JcaOpenPGPImplementation(Provider provider, SecureRandom secureRandom) {
        this.provider = provider;
        this.secureRandom = secureRandom;
    }

    @Override
    public PGPObjectFactory pgpObjectFactory(InputStream inputStream) {
        return new JcaPGPObjectFactory(inputStream).setThrowForUnknownCriticalPackets(true);
    }

    @Override
    public PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider() {
        JcaPGPContentVerifierBuilderProvider jcaPGPContentVerifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider();
        jcaPGPContentVerifierBuilderProvider.setProvider(this.provider);
        return jcaPGPContentVerifierBuilderProvider;
    }

    @Override
    public PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider() {
        JcaPGPDigestCalculatorProviderBuilder jcaPGPDigestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
        jcaPGPDigestCalculatorProviderBuilder.setProvider(this.provider);
        JcePBESecretKeyDecryptorBuilderProvider jcePBESecretKeyDecryptorBuilderProvider = new JcePBESecretKeyDecryptorBuilderProvider(jcaPGPDigestCalculatorProviderBuilder).setProvider(this.provider);
        return jcePBESecretKeyDecryptorBuilderProvider;
    }

    @Override
    public PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int n) {
        JcePGPDataEncryptorBuilder jcePGPDataEncryptorBuilder = new JcePGPDataEncryptorBuilder(n);
        jcePGPDataEncryptorBuilder.setProvider(this.provider);
        jcePGPDataEncryptorBuilder.setSecureRandom(this.secureRandom);
        return jcePGPDataEncryptorBuilder;
    }

    @Override
    public PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        JcePublicKeyKeyEncryptionMethodGenerator jcePublicKeyKeyEncryptionMethodGenerator = new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey);
        jcePublicKeyKeyEncryptionMethodGenerator.setProvider(this.provider);
        jcePublicKeyKeyEncryptionMethodGenerator.setSecureRandom(this.secureRandom);
        return jcePublicKeyKeyEncryptionMethodGenerator;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] cArray) {
        JcePBEKeyEncryptionMethodGenerator jcePBEKeyEncryptionMethodGenerator = new JcePBEKeyEncryptionMethodGenerator(cArray);
        jcePBEKeyEncryptionMethodGenerator.setProvider(this.provider);
        jcePBEKeyEncryptionMethodGenerator.setSecureRandom(this.secureRandom);
        return jcePBEKeyEncryptionMethodGenerator;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        JcePBEKeyEncryptionMethodGenerator jcePBEKeyEncryptionMethodGenerator = new JcePBEKeyEncryptionMethodGenerator(cArray, argon2Params);
        jcePBEKeyEncryptionMethodGenerator.setProvider(this.provider);
        jcePBEKeyEncryptionMethodGenerator.setSecureRandom(this.secureRandom);
        return jcePBEKeyEncryptionMethodGenerator;
    }

    @Override
    public PGPContentSignerBuilder pgpContentSignerBuilder(int n, int n2) {
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(n, n2);
        jcaPGPContentSignerBuilder.setProvider(this.provider);
        jcaPGPContentSignerBuilder.setDigestProvider(this.provider);
        jcaPGPContentSignerBuilder.setSecureRandom(this.secureRandom);
        return jcaPGPContentSignerBuilder;
    }

    @Override
    public PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] cArray) throws PGPException {
        return new JcePBEDataDecryptorFactoryBuilder(this.pgpDigestCalculatorProvider()).setProvider(this.provider).build(cArray);
    }

    @Override
    public SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey pGPSessionKey) {
        return new JceSessionKeyDataDecryptorFactoryBuilder().setProvider(this.provider).build(pGPSessionKey);
    }

    @Override
    public PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        return new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(this.provider).setContentProvider(this.provider).build(pGPPrivateKey);
    }

    @Override
    public PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException {
        return new JcaPGPDigestCalculatorProviderBuilder().setProvider(this.provider).build();
    }

    @Override
    public PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider() {
        return new JcaPGPKeyPairGeneratorProvider().setProvider(this.provider).setSecureRandom(this.secureRandom);
    }

    @Override
    public PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int n) {
        return new JcaPGPContentSignerBuilderProvider(n).setSecurityProvider(this.provider).setDigestProvider(this.provider).setSecureRandom(this.secureRandom);
    }

    @Override
    public KeyFingerPrintCalculator keyFingerPrintCalculator() {
        return new JcaKeyFingerprintCalculator().setProvider(this.provider);
    }

    @Override
    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean bl) throws PGPException {
        if (bl) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(this.provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory(7, 96).setProvider(this.provider);
    }

    @Override
    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean bl, int n, int n2) throws PGPException {
        if (bl) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(this.provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory(n, n2).setProvider(this.provider);
    }
}

