/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api.exception;

import shadow.org.bouncycastle.openpgp.api.OpenPGPCertificate;
import shadow.org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;

public class KeyPassphraseException
extends OpenPGPKeyException {
    private final Exception cause;

    public KeyPassphraseException(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, Exception exception) {
        super(openPGPComponentKey, KeyPassphraseException.componentKeyErrorMessage(openPGPComponentKey, exception));
        this.cause = exception;
    }

    private static String componentKeyErrorMessage(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, Exception exception) {
        if (openPGPComponentKey.getKeyIdentifier().equals(openPGPComponentKey.getCertificate().getKeyIdentifier())) {
            return "Cannot unlock primary key " + openPGPComponentKey.getKeyIdentifier() + ": " + exception.getMessage();
        }
        return "Cannot unlock subkey " + openPGPComponentKey.getKeyIdentifier() + " from key " + openPGPComponentKey.getCertificate().getKeyIdentifier() + ": " + exception.getMessage();
    }

    @Override
    public Exception getCause() {
        return this.cause;
    }
}

