/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api.exception;

import shadow.org.bouncycastle.openpgp.api.OpenPGPCertificate;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKey;
import shadow.org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;

public class InvalidSigningKeyException
extends OpenPGPKeyException {
    public InvalidSigningKeyException(OpenPGPKey openPGPKey) {
        super(openPGPKey, "The key " + openPGPKey.getKeyIdentifier() + " does not contain any usable component keys capable of signing.");
    }

    public InvalidSigningKeyException(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        super(openPGPComponentKey, InvalidSigningKeyException.componentKeyErrorMessage(openPGPComponentKey));
    }

    private static String componentKeyErrorMessage(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        if (openPGPComponentKey.getKeyIdentifier().equals(openPGPComponentKey.getCertificate().getKeyIdentifier())) {
            return "The primary key " + openPGPComponentKey.getKeyIdentifier() + " is not usable for signing.";
        }
        return "The subkey " + openPGPComponentKey.getKeyIdentifier() + " from the certificate " + openPGPComponentKey.getCertificate().getKeyIdentifier() + " is not usable for signing.";
    }
}

