/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api.bc;

import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.S2K;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPObjectFactory;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSessionKey;
import shadow.org.bouncycastle.openpgp.api.OpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.bc.BcAEADSecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.bc.BcCFBSecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPGPKeyPairGeneratorProvider;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.bc.BcSessionKeyDataDecryptorFactory;

public class BcOpenPGPImplementation
extends OpenPGPImplementation {
    @Override
    public PGPObjectFactory pgpObjectFactory(InputStream inputStream) {
        return new BcPGPObjectFactory(inputStream).setThrowForUnknownCriticalPackets(true);
    }

    @Override
    public PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider() {
        return new BcPGPContentVerifierBuilderProvider();
    }

    @Override
    public PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider() {
        return new BcPBESecretKeyDecryptorBuilderProvider();
    }

    @Override
    public PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int n) {
        return new BcPGPDataEncryptorBuilder(n);
    }

    @Override
    public PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        return new BcPublicKeyKeyEncryptionMethodGenerator(pGPPublicKey);
    }

    @Override
    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] cArray) {
        return new BcPBEKeyEncryptionMethodGenerator(cArray);
    }

    @Override
    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        return new BcPBEKeyEncryptionMethodGenerator(cArray, argon2Params);
    }

    @Override
    public PGPContentSignerBuilder pgpContentSignerBuilder(int n, int n2) {
        return new BcPGPContentSignerBuilder(n, n2);
    }

    @Override
    public PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] cArray) throws PGPException {
        return new BcPBEDataDecryptorFactory(cArray, this.pgpDigestCalculatorProvider());
    }

    @Override
    public SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey pGPSessionKey) {
        return new BcSessionKeyDataDecryptorFactory(pGPSessionKey);
    }

    @Override
    public PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        return new BcPublicKeyDataDecryptorFactory(pGPPrivateKey);
    }

    @Override
    public PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException {
        return new BcPGPDigestCalculatorProvider();
    }

    @Override
    public PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider() {
        return new BcPGPKeyPairGeneratorProvider();
    }

    @Override
    public PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int n) {
        return new BcPGPContentSignerBuilderProvider(n);
    }

    @Override
    public KeyFingerPrintCalculator keyFingerPrintCalculator() {
        return new BcKeyFingerprintCalculator();
    }

    @Override
    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean bl) {
        return this.pbeSecretKeyEncryptorFactory(bl, 7, 96);
    }

    @Override
    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean bl, int n, int n2) {
        if (bl) {
            return new BcAEADSecretKeyEncryptorFactory();
        }
        return new BcCFBSecretKeyEncryptorFactory(n, n2);
    }
}

