/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.util.Date;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPKeyPair;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPSignatureGenerator;
import shadow.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import shadow.org.bouncycastle.openpgp.api.OpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.api.SignatureParameters;

class Utils {
    Utils() {
    }

    static void addEmbeddedSiganture(PGPSignature pGPSignature, PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
        if (pGPSignature != null) {
            try {
                pGPSignatureSubpacketGenerator.addEmbeddedSignature(true, pGPSignature);
            }
            catch (IOException iOException) {
                throw new PGPException("Cannot encode embedded back-signature.", iOException);
            }
        }
    }

    static PGPSignature getBackSignature(PGPKeyPair pGPKeyPair, SignatureParameters signatureParameters, PGPPublicKey pGPPublicKey, OpenPGPImplementation openPGPImplementation, Date date) throws PGPException {
        PGPSignature pGPSignature = null;
        if (signatureParameters != null) {
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(openPGPImplementation, pGPKeyPair.getPublicKey(), pGPKeyPair.getPrivateKey(), signatureParameters, date, null);
            pGPSignature = pGPSignatureGenerator.generateCertification(pGPPublicKey, pGPKeyPair.getPublicKey());
        }
        return pGPSignature;
    }

    static PGPPublicKey injectCertification(PGPPublicKey pGPPublicKey, PGPSignatureGenerator pGPSignatureGenerator, PGPPublicKey pGPPublicKey2) throws PGPException {
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPPublicKey2, pGPPublicKey);
        return PGPPublicKey.addCertification(pGPPublicKey, pGPSignature);
    }

    static PGPPublicKey injectCertification(PGPPublicKey pGPPublicKey, PGPSignatureGenerator pGPSignatureGenerator) throws PGPException {
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPPublicKey);
        return PGPPublicKey.addCertification(pGPPublicKey, pGPSignature);
    }

    static PGPPublicKey injectCertification(String string, PGPPublicKey pGPPublicKey, PGPSignatureGenerator pGPSignatureGenerator) throws PGPException {
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(string, pGPPublicKey);
        return PGPPublicKey.addCertification(pGPPublicKey, string, pGPSignature);
    }

    static PGPSignatureGenerator getPgpSignatureGenerator(OpenPGPImplementation openPGPImplementation, PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey, SignatureParameters signatureParameters, Date date, HashedSubpacketsOperation hashedSubpacketsOperation) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(openPGPImplementation.pgpContentSignerBuilder(pGPPublicKey.getAlgorithm(), signatureParameters.getSignatureHashAlgorithmId()), pGPPublicKey);
        pGPSignatureGenerator.init(signatureParameters.getSignatureType(), pGPPrivateKey);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setIssuerFingerprint(true, pGPPublicKey);
        if (date != null) {
            pGPSignatureSubpacketGenerator.setSignatureCreationTime(date);
        }
        if (hashedSubpacketsOperation != null) {
            hashedSubpacketsOperation.operate(pGPSignatureSubpacketGenerator);
        }
        signatureParameters.applyToHashedSubpackets(pGPSignatureSubpacketGenerator);
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator2 = signatureParameters.applyToUnhashedSubpackets(pGPSignatureSubpacketGenerator2);
        pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketGenerator2.generate());
        return pGPSignatureGenerator;
    }

    static SignatureParameters applySignatureParameters(SignatureParameters.Callback callback, SignatureParameters signatureParameters) {
        if (callback != null) {
            signatureParameters = callback.apply(signatureParameters);
        }
        return signatureParameters;
    }

    public static interface HashedSubpacketsOperation {
        public void operate(PGPSignatureSubpacketGenerator var1) throws PGPException;
    }
}

