/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.util.Date;
import shadow.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import shadow.org.bouncycastle.openpgp.api.OpenPGPPolicy;
import shadow.org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;
import shadow.org.bouncycastle.util.Arrays;

public class SignatureParameters {
    private int signatureType;
    private Date signatureCreationTime = new Date();
    private int signatureHashAlgorithmId;
    private SignatureSubpacketsFunction hashedSubpacketsFunction;
    private SignatureSubpacketsFunction unhashedSubpacketsFunction;
    private final int[] allowedSignatureTypes;

    private SignatureParameters(int ... nArray) {
        this.allowedSignatureTypes = nArray;
    }

    public static SignatureParameters directKeySignature(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(31).setSignatureType(31).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters keyRevocation(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(32).setSignatureType(32).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters certification(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(16, 17, 18, 19).setSignatureType(19).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters subkeyBinding(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(24).setSignatureType(24).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters subkeyRevocation(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(40).setSignatureType(40).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters primaryKeyBinding(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(25).setSignatureType(25).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters certificationRevocation(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(48).setSignatureType(48).setSignatureHashAlgorithm(openPGPPolicy.getDefaultCertificationSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public static SignatureParameters dataSignature(OpenPGPPolicy openPGPPolicy) {
        return new SignatureParameters(0, 1).setSignatureType(0).setSignatureHashAlgorithm(openPGPPolicy.getDefaultDocumentSignatureHashAlgorithm()).setSignatureCreationTime(new Date());
    }

    public SignatureParameters setSignatureType(int n) {
        if (!Arrays.contains(this.allowedSignatureTypes, n)) {
            throw new IllegalArgumentException("Illegal signature type provided.");
        }
        this.signatureType = n;
        return this;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public SignatureParameters setSignatureCreationTime(Date date) {
        if (date == null) {
            throw new NullPointerException("Signature creation time cannot be null.");
        }
        this.signatureCreationTime = date;
        return this;
    }

    public Date getSignatureCreationTime() {
        return this.signatureCreationTime;
    }

    public SignatureParameters setSignatureHashAlgorithm(int n) {
        this.signatureHashAlgorithmId = n;
        return this;
    }

    public int getSignatureHashAlgorithmId() {
        return this.signatureHashAlgorithmId;
    }

    public SignatureParameters setHashedSubpacketsFunction(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.hashedSubpacketsFunction = signatureSubpacketsFunction;
        return this;
    }

    PGPSignatureSubpacketGenerator applyToHashedSubpackets(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
        if (this.hashedSubpacketsFunction != null) {
            return this.hashedSubpacketsFunction.apply(pGPSignatureSubpacketGenerator);
        }
        return pGPSignatureSubpacketGenerator;
    }

    public SignatureParameters setUnhashedSubpacketsFunction(SignatureSubpacketsFunction signatureSubpacketsFunction) {
        this.unhashedSubpacketsFunction = signatureSubpacketsFunction;
        return this;
    }

    PGPSignatureSubpacketGenerator applyToUnhashedSubpackets(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
        if (this.unhashedSubpacketsFunction != null) {
            return this.unhashedSubpacketsFunction.apply(pGPSignatureSubpacketGenerator);
        }
        return pGPSignatureSubpacketGenerator;
    }

    public static interface Callback {
        default public SignatureParameters apply(SignatureParameters signatureParameters) {
            return signatureParameters;
        }

        public static class Util {
            public static Callback modifyHashedSubpackets(final SignatureSubpacketsFunction signatureSubpacketsFunction) {
                return new Callback(){

                    @Override
                    public SignatureParameters apply(SignatureParameters signatureParameters) {
                        return signatureParameters.setHashedSubpacketsFunction(signatureSubpacketsFunction);
                    }
                };
            }
        }
    }
}

