/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import shadow.org.bouncycastle.bcpg.SignatureSubpacket;
import shadow.org.bouncycastle.bcpg.sig.NotationData;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public interface OpenPGPPolicy {
    default public boolean isAcceptableSigningKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    default public boolean isAcceptableVerificationKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    default public boolean isAcceptableEncryptionKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    default public boolean isAcceptableDecryptionKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKey(pGPPublicKey);
    }

    default public boolean isAcceptablePublicKey(PGPPublicKey pGPPublicKey) {
        return this.isAcceptablePublicKeyStrength(pGPPublicKey.getAlgorithm(), pGPPublicKey.getBitStrength());
    }

    default public boolean isAcceptableSignature(PGPSignature pGPSignature) {
        return this.hasAcceptableSignatureHashAlgorithm(pGPSignature) && this.hasNoCriticalUnknownNotations(pGPSignature) && this.hasNoCriticalUnknownSubpackets(pGPSignature);
    }

    default public boolean hasAcceptableSignatureHashAlgorithm(PGPSignature pGPSignature) {
        switch (pGPSignature.getSignatureType()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 31: {
                return this.hasAcceptableCertificationSignatureHashAlgorithm(pGPSignature);
            }
            case 32: 
            case 40: 
            case 48: {
                return this.hasAcceptableRevocationSignatureHashAlgorithm(pGPSignature);
            }
        }
        return this.hasAcceptableDocumentSignatureHashAlgorithm(pGPSignature);
    }

    default public boolean hasAcceptableDocumentSignatureHashAlgorithm(PGPSignature pGPSignature) {
        return this.isAcceptableDocumentSignatureHashAlgorithm(pGPSignature.getHashAlgorithm(), pGPSignature.getCreationTime());
    }

    default public boolean hasAcceptableRevocationSignatureHashAlgorithm(PGPSignature pGPSignature) {
        return this.isAcceptableRevocationSignatureHashAlgorithm(pGPSignature.getHashAlgorithm(), pGPSignature.getCreationTime());
    }

    default public boolean hasAcceptableCertificationSignatureHashAlgorithm(PGPSignature pGPSignature) {
        return this.isAcceptableCertificationSignatureHashAlgorithm(pGPSignature.getHashAlgorithm(), pGPSignature.getCreationTime());
    }

    default public boolean hasNoCriticalUnknownNotations(PGPSignature pGPSignature) {
        NotationData[] notationDataArray;
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        if (pGPSignatureSubpacketVector == null) {
            return true;
        }
        OpenPGPNotationRegistry openPGPNotationRegistry = this.getNotationRegistry();
        for (NotationData notationData : notationDataArray = pGPSignatureSubpacketVector.getNotationDataOccurrences()) {
            if (!notationData.isCritical() || openPGPNotationRegistry.isNotationKnown(notationData.getNotationName())) continue;
            return false;
        }
        return true;
    }

    default public boolean hasNoCriticalUnknownSubpackets(PGPSignature pGPSignature) {
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        if (pGPSignatureSubpacketVector == null) {
            return true;
        }
        for (SignatureSubpacket signatureSubpacket : pGPSignatureSubpacketVector.toArray()) {
            if (!signatureSubpacket.isCritical() || !signatureSubpacket.getClass().equals(SignatureSubpacket.class) || this.isKnownSignatureSubpacket(signatureSubpacket.getType())) continue;
            return false;
        }
        return true;
    }

    default public boolean isKnownSignatureSubpacket(int n) {
        return false;
    }

    public boolean isAcceptableDocumentSignatureHashAlgorithm(int var1, Date var2);

    public boolean isAcceptableRevocationSignatureHashAlgorithm(int var1, Date var2);

    public boolean isAcceptableCertificationSignatureHashAlgorithm(int var1, Date var2);

    public int getDefaultCertificationSignatureHashAlgorithm();

    public int getDefaultDocumentSignatureHashAlgorithm();

    public boolean isAcceptableSymmetricKeyAlgorithm(int var1);

    public int getDefaultSymmetricKeyAlgorithm();

    public boolean isAcceptablePublicKeyStrength(int var1, int var2);

    public OpenPGPNotationRegistry getNotationRegistry();

    public static class OpenPGPNotationRegistry {
        private final Set<String> knownNotations = new HashSet<String>();

        public boolean isNotationKnown(String string) {
            return this.knownNotations.contains(string);
        }

        public void addKnownNotation(String string) {
            this.knownNotations.add(string);
        }
    }
}

